/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;

public final class TestRunStarted {
    private final Timestamp timestamp;
    private final String id;

    public TestRunStarted(Timestamp timestamp, String id) {
        this.timestamp = Objects.requireNonNull(timestamp, "TestRunStarted.timestamp cannot be null");
        this.id = id;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRunStarted that = (TestRunStarted)o;
        return this.timestamp.equals(that.timestamp) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.id);
    }

    public String toString() {
        return "TestRunStarted{timestamp=" + this.timestamp + ", id=" + this.id + '}';
    }
}

