
package io.cucumber.messages.types;



/**
 * *
 *  Represents a single argument extracted from a step match and passed to a step definition.
 *  This is used for the following purposes:
 *  - Construct an argument to pass to a step definition (possibly through a parameter type transform)
 *  - Highlight the matched parameter in rich formatters such as the HTML formatter
 * 
 *  This message closely matches the `Argument` class in the `cucumber-expressions` library.
 * 
 */
public class StepMatchArgument {

    /**
     * 
     * (Required)
     * 
     */
    private Group group;
    private String parameterTypeName;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StepMatchArgument() {
    }

    /**
     * 
     * @param parameterTypeName
     * @param group
     */
    public StepMatchArgument(Group group, String parameterTypeName) {
        super();
        this.group = group;
        this.parameterTypeName = parameterTypeName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Group getGroup() {
        return group;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setGroup(Group group) {
        this.group = group;
    }

    public String getParameterTypeName() {
        return parameterTypeName;
    }

    public void setParameterTypeName(String parameterTypeName) {
        this.parameterTypeName = parameterTypeName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StepMatchArgument.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("group");
        sb.append('=');
        sb.append(((this.group == null)?"<null>":this.group));
        sb.append(',');
        sb.append("parameterTypeName");
        sb.append('=');
        sb.append(((this.parameterTypeName == null)?"<null>":this.parameterTypeName));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.parameterTypeName == null)? 0 :this.parameterTypeName.hashCode()));
        result = ((result* 31)+((this.group == null)? 0 :this.group.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof StepMatchArgument) == false) {
            return false;
        }
        StepMatchArgument rhs = ((StepMatchArgument) other);
        return (((this.parameterTypeName == rhs.parameterTypeName)||((this.parameterTypeName!= null)&&this.parameterTypeName.equals(rhs.parameterTypeName)))&&((this.group == rhs.group)||((this.group!= null)&&this.group.equals(rhs.group))));
    }

}
