
package io.cucumber.messages.types;



/**
 * A step
 * 
 */
public class Step {

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    private Location location;
    /**
     * 
     * (Required)
     * 
     */
    private String keyword;
    /**
     * 
     * (Required)
     * 
     */
    private String text;
    private DocString docString;
    private DataTable dataTable;
    /**
     * Unique ID to be able to reference the Step from PickleStep
     * (Required)
     * 
     */
    private String id;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Step() {
    }

    /**
     * 
     * @param dataTable
     * @param docString
     * @param location
     * @param text
     * @param id
     * @param keyword
     */
    public Step(Location location, String keyword, String text, DocString docString, DataTable dataTable, String id) {
        super();
        this.location = location;
        this.keyword = keyword;
        this.text = text;
        this.docString = docString;
        this.dataTable = dataTable;
        this.id = id;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getKeyword() {
        return keyword;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getText() {
        return text;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setText(String text) {
        this.text = text;
    }

    public DocString getDocString() {
        return docString;
    }

    public void setDocString(DocString docString) {
        this.docString = docString;
    }

    public DataTable getDataTable() {
        return dataTable;
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTable = dataTable;
    }

    /**
     * Unique ID to be able to reference the Step from PickleStep
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * Unique ID to be able to reference the Step from PickleStep
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Step.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("keyword");
        sb.append('=');
        sb.append(((this.keyword == null)?"<null>":this.keyword));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("docString");
        sb.append('=');
        sb.append(((this.docString == null)?"<null>":this.docString));
        sb.append(',');
        sb.append("dataTable");
        sb.append('=');
        sb.append(((this.dataTable == null)?"<null>":this.dataTable));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataTable == null)? 0 :this.dataTable.hashCode()));
        result = ((result* 31)+((this.docString == null)? 0 :this.docString.hashCode()));
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.keyword == null)? 0 :this.keyword.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Step) == false) {
            return false;
        }
        Step rhs = ((Step) other);
        return (((((((this.dataTable == rhs.dataTable)||((this.dataTable!= null)&&this.dataTable.equals(rhs.dataTable)))&&((this.docString == rhs.docString)||((this.docString!= null)&&this.docString.equals(rhs.docString))))&&((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.keyword == rhs.keyword)||((this.keyword!= null)&&this.keyword.equals(rhs.keyword))));
    }

}
