
package io.cucumber.messages.types;

import java.util.HashMap;
import java.util.Map;


/**
 * //// Source
 * 
 * *
 *  A source file, typically a Gherkin document or Java/Ruby/JavaScript source code
 * 
 */
public class Source {

    /**
     * *
     *  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
     *  of the source, typically a file path relative to the root directory
     * (Required)
     * 
     */
    private String uri;
    /**
     * The contents of the file
     * (Required)
     * 
     */
    private String data;
    /**
     * The media type of the file. Can be used to specify custom types, such as
     *  text/x.cucumber.gherkin+plain
     * (Required)
     * 
     */
    private Source.MediaType mediaType;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Source() {
    }

    /**
     * 
     * @param data
     * @param mediaType
     * @param uri
     */
    public Source(String uri, String data, Source.MediaType mediaType) {
        super();
        this.uri = uri;
        this.data = data;
        this.mediaType = mediaType;
    }

    /**
     * *
     *  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
     *  of the source, typically a file path relative to the root directory
     * (Required)
     * 
     */
    public String getUri() {
        return uri;
    }

    /**
     * *
     *  The [URI](https://en.wikipedia.org/wiki/Uniform_Resource_Identifier)
     *  of the source, typically a file path relative to the root directory
     * (Required)
     * 
     */
    public void setUri(String uri) {
        this.uri = uri;
    }

    /**
     * The contents of the file
     * (Required)
     * 
     */
    public String getData() {
        return data;
    }

    /**
     * The contents of the file
     * (Required)
     * 
     */
    public void setData(String data) {
        this.data = data;
    }

    /**
     * The media type of the file. Can be used to specify custom types, such as
     *  text/x.cucumber.gherkin+plain
     * (Required)
     * 
     */
    public Source.MediaType getMediaType() {
        return mediaType;
    }

    /**
     * The media type of the file. Can be used to specify custom types, such as
     *  text/x.cucumber.gherkin+plain
     * (Required)
     * 
     */
    public void setMediaType(Source.MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Source.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("uri");
        sb.append('=');
        sb.append(((this.uri == null)?"<null>":this.uri));
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(((this.data == null)?"<null>":this.data));
        sb.append(',');
        sb.append("mediaType");
        sb.append('=');
        sb.append(((this.mediaType == null)?"<null>":this.mediaType));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.mediaType == null)? 0 :this.mediaType.hashCode()));
        result = ((result* 31)+((this.data == null)? 0 :this.data.hashCode()));
        result = ((result* 31)+((this.uri == null)? 0 :this.uri.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Source) == false) {
            return false;
        }
        Source rhs = ((Source) other);
        return ((((this.mediaType == rhs.mediaType)||((this.mediaType!= null)&&this.mediaType.equals(rhs.mediaType)))&&((this.data == rhs.data)||((this.data!= null)&&this.data.equals(rhs.data))))&&((this.uri == rhs.uri)||((this.uri!= null)&&this.uri.equals(rhs.uri))));
    }


    /**
     * The media type of the file. Can be used to specify custom types, such as
     *  text/x.cucumber.gherkin+plain
     * 
     */
    public enum MediaType {

        TEXT_X_CUCUMBER_GHERKIN_PLAIN("text/x.cucumber.gherkin+plain"),
        TEXT_X_CUCUMBER_GHERKIN_MARKDOWN("text/x.cucumber.gherkin+markdown");
        private final String value;
        private final static Map<String, Source.MediaType> CONSTANTS = new HashMap<String, Source.MediaType>();

        static {
            for (Source.MediaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MediaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static Source.MediaType fromValue(String value) {
            Source.MediaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
