
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;


/**
 * //// Pickles
 * 
 * *
 *  A `Pickle` represents a template for a `TestCase`. It is typically derived
 *  from another format, such as [GherkinDocument](#io.cucumber.messages.GherkinDocument).
 *  In the future a `Pickle` may be derived from other formats such as Markdown or
 *  Excel files.
 * 
 *  By making `Pickle` the main data structure Cucumber uses for execution, the
 *  implementation of Cucumber itself becomes simpler, as it doesn't have to deal
 *  with the complex structure of a [GherkinDocument](#io.cucumber.messages.GherkinDocument).
 * 
 *  Each `PickleStep` of a `Pickle` is matched with a `StepDefinition` to create a `TestCase`
 * 
 */
public class Pickle {

    /**
     * *
     *  A unique id for the pickle. This is a [SHA1](https://en.wikipedia.org/wiki/SHA-1) hash
     *  from the source data and the `locations` of the pickle.
     *  This ID will change if source the file is modified.
     * (Required)
     * 
     */
    private String id;
    /**
     * The uri of the source file
     * (Required)
     * 
     */
    private String uri;
    /**
     * The name of the pickle
     * (Required)
     * 
     */
    private String name;
    /**
     * The language of the pickle
     * (Required)
     * 
     */
    private String language;
    /**
     * One or more steps
     * (Required)
     * 
     */
    private List<PickleStep> steps = new ArrayList<PickleStep>();
    /**
     * *
     *  One or more tags. If this pickle is constructed from a Gherkin document,
     *  It includes inherited tags from the `Feature` as well.
     * (Required)
     * 
     */
    private List<PickleTag> tags = new ArrayList<PickleTag>();
    /**
     * *
     *  Points to the AST node locations of the pickle. The last one represents the unique
     *  id of the pickle. A pickle constructed from `Examples` will have the first
     *  id originating from the `Scenario` AST node, and the second from the `TableRow` AST node.
     * (Required)
     * 
     */
    private List<String> astNodeIds = new ArrayList<String>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Pickle() {
    }

    /**
     * 
     * @param name
     * @param language
     * @param id
     * @param uri
     * @param steps
     * @param astNodeIds
     * @param tags
     */
    public Pickle(String id, String uri, String name, String language, List<PickleStep> steps, List<PickleTag> tags, List<String> astNodeIds) {
        super();
        this.id = id;
        this.uri = uri;
        this.name = name;
        this.language = language;
        this.steps = steps;
        this.tags = tags;
        this.astNodeIds = astNodeIds;
    }

    /**
     * *
     *  A unique id for the pickle. This is a [SHA1](https://en.wikipedia.org/wiki/SHA-1) hash
     *  from the source data and the `locations` of the pickle.
     *  This ID will change if source the file is modified.
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * *
     *  A unique id for the pickle. This is a [SHA1](https://en.wikipedia.org/wiki/SHA-1) hash
     *  from the source data and the `locations` of the pickle.
     *  This ID will change if source the file is modified.
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * The uri of the source file
     * (Required)
     * 
     */
    public String getUri() {
        return uri;
    }

    /**
     * The uri of the source file
     * (Required)
     * 
     */
    public void setUri(String uri) {
        this.uri = uri;
    }

    /**
     * The name of the pickle
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name of the pickle
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * The language of the pickle
     * (Required)
     * 
     */
    public String getLanguage() {
        return language;
    }

    /**
     * The language of the pickle
     * (Required)
     * 
     */
    public void setLanguage(String language) {
        this.language = language;
    }

    /**
     * One or more steps
     * (Required)
     * 
     */
    public List<PickleStep> getSteps() {
        return steps;
    }

    /**
     * One or more steps
     * (Required)
     * 
     */
    public void setSteps(List<PickleStep> steps) {
        this.steps = steps;
    }

    /**
     * *
     *  One or more tags. If this pickle is constructed from a Gherkin document,
     *  It includes inherited tags from the `Feature` as well.
     * (Required)
     * 
     */
    public List<PickleTag> getTags() {
        return tags;
    }

    /**
     * *
     *  One or more tags. If this pickle is constructed from a Gherkin document,
     *  It includes inherited tags from the `Feature` as well.
     * (Required)
     * 
     */
    public void setTags(List<PickleTag> tags) {
        this.tags = tags;
    }

    /**
     * *
     *  Points to the AST node locations of the pickle. The last one represents the unique
     *  id of the pickle. A pickle constructed from `Examples` will have the first
     *  id originating from the `Scenario` AST node, and the second from the `TableRow` AST node.
     * (Required)
     * 
     */
    public List<String> getAstNodeIds() {
        return astNodeIds;
    }

    /**
     * *
     *  Points to the AST node locations of the pickle. The last one represents the unique
     *  id of the pickle. A pickle constructed from `Examples` will have the first
     *  id originating from the `Scenario` AST node, and the second from the `TableRow` AST node.
     * (Required)
     * 
     */
    public void setAstNodeIds(List<String> astNodeIds) {
        this.astNodeIds = astNodeIds;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Pickle.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("uri");
        sb.append('=');
        sb.append(((this.uri == null)?"<null>":this.uri));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("steps");
        sb.append('=');
        sb.append(((this.steps == null)?"<null>":this.steps));
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(((this.tags == null)?"<null>":this.tags));
        sb.append(',');
        sb.append("astNodeIds");
        sb.append('=');
        sb.append(((this.astNodeIds == null)?"<null>":this.astNodeIds));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.uri == null)? 0 :this.uri.hashCode()));
        result = ((result* 31)+((this.steps == null)? 0 :this.steps.hashCode()));
        result = ((result* 31)+((this.astNodeIds == null)? 0 :this.astNodeIds.hashCode()));
        result = ((result* 31)+((this.tags == null)? 0 :this.tags.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Pickle) == false) {
            return false;
        }
        Pickle rhs = ((Pickle) other);
        return ((((((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.uri == rhs.uri)||((this.uri!= null)&&this.uri.equals(rhs.uri))))&&((this.steps == rhs.steps)||((this.steps!= null)&&this.steps.equals(rhs.steps))))&&((this.astNodeIds == rhs.astNodeIds)||((this.astNodeIds!= null)&&this.astNodeIds.equals(rhs.astNodeIds))))&&((this.tags == rhs.tags)||((this.tags!= null)&&this.tags.equals(rhs.tags))));
    }

}
