
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class ParameterType {

    /**
     * The name is unique, so we don't need an id.
     * (Required)
     * 
     */
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    private List<String> regularExpressions = new ArrayList<String>();
    /**
     * 
     * (Required)
     * 
     */
    private Boolean preferForRegularExpressionMatch;
    /**
     * 
     * (Required)
     * 
     */
    private Boolean useForSnippets;
    /**
     * 
     * (Required)
     * (Required)
     * 
     */
    private String id;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ParameterType() {
    }

    /**
     * 
     * @param preferForRegularExpressionMatch
     * @param name
     * @param regularExpressions
     * @param id
     * @param useForSnippets
     */
    public ParameterType(String name, List<String> regularExpressions, Boolean preferForRegularExpressionMatch, Boolean useForSnippets, String id) {
        super();
        this.name = name;
        this.regularExpressions = regularExpressions;
        this.preferForRegularExpressionMatch = preferForRegularExpressionMatch;
        this.useForSnippets = useForSnippets;
        this.id = id;
    }

    /**
     * The name is unique, so we don't need an id.
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * The name is unique, so we don't need an id.
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<String> getRegularExpressions() {
        return regularExpressions;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setRegularExpressions(List<String> regularExpressions) {
        this.regularExpressions = regularExpressions;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getPreferForRegularExpressionMatch() {
        return preferForRegularExpressionMatch;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setPreferForRegularExpressionMatch(Boolean preferForRegularExpressionMatch) {
        this.preferForRegularExpressionMatch = preferForRegularExpressionMatch;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Boolean getUseForSnippets() {
        return useForSnippets;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setUseForSnippets(Boolean useForSnippets) {
        this.useForSnippets = useForSnippets;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ParameterType.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("regularExpressions");
        sb.append('=');
        sb.append(((this.regularExpressions == null)?"<null>":this.regularExpressions));
        sb.append(',');
        sb.append("preferForRegularExpressionMatch");
        sb.append('=');
        sb.append(((this.preferForRegularExpressionMatch == null)?"<null>":this.preferForRegularExpressionMatch));
        sb.append(',');
        sb.append("useForSnippets");
        sb.append('=');
        sb.append(((this.useForSnippets == null)?"<null>":this.useForSnippets));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.preferForRegularExpressionMatch == null)? 0 :this.preferForRegularExpressionMatch.hashCode()));
        result = ((result* 31)+((this.regularExpressions == null)? 0 :this.regularExpressions.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.useForSnippets == null)? 0 :this.useForSnippets.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ParameterType) == false) {
            return false;
        }
        ParameterType rhs = ((ParameterType) other);
        return ((((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.preferForRegularExpressionMatch == rhs.preferForRegularExpressionMatch)||((this.preferForRegularExpressionMatch!= null)&&this.preferForRegularExpressionMatch.equals(rhs.preferForRegularExpressionMatch))))&&((this.regularExpressions == rhs.regularExpressions)||((this.regularExpressions!= null)&&this.regularExpressions.equals(rhs.regularExpressions))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.useForSnippets == rhs.useForSnippets)||((this.useForSnippets!= null)&&this.useForSnippets.equals(rhs.useForSnippets))));
    }

}
