/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.api.testng.CucumberExceptionWrapper;
import cucumber.api.testng.CucumberFeatureWrapperImpl;
import cucumber.api.testng.FeatureResultListener;
import cucumber.api.testng.TestNgReporter;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import java.util.ArrayList;
import java.util.List;

public class TestNGCucumberRunner {
    private Runtime runtime;
    private RuntimeOptions runtimeOptions;
    private ResourceLoader resourceLoader;
    private FeatureResultListener resultListener;
    private ClassLoader classLoader;

    public TestNGCucumberRunner(Class clazz) {
        this.classLoader = clazz.getClassLoader();
        this.resourceLoader = new MultiLoader(this.classLoader);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        this.runtimeOptions = runtimeOptionsFactory.create();
        TestNgReporter reporter = new TestNgReporter(System.out);
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(this.resourceLoader, this.classLoader);
        this.resultListener = new FeatureResultListener(this.runtimeOptions.reporter(this.classLoader), this.runtimeOptions.isStrict());
        this.runtime = new Runtime(this.resourceLoader, (ClassFinder)classFinder, this.classLoader, this.runtimeOptions);
    }

    public void runCukes() {
        for (CucumberFeature cucumberFeature : this.getFeatures()) {
            cucumberFeature.run(this.runtimeOptions.formatter(this.classLoader), (Reporter)this.resultListener, this.runtime);
        }
        this.finish();
        if (!this.resultListener.isPassed()) {
            throw new CucumberException(this.resultListener.getFirstError());
        }
    }

    public void runCucumber(CucumberFeature cucumberFeature) {
        this.resultListener.startFeature();
        cucumberFeature.run(this.runtimeOptions.formatter(this.classLoader), (Reporter)this.resultListener, this.runtime);
        if (!this.resultListener.isPassed()) {
            throw new CucumberException(this.resultListener.getFirstError());
        }
    }

    public void finish() {
        Formatter formatter = this.runtimeOptions.formatter(this.classLoader);
        formatter.done();
        formatter.close();
        this.runtime.printSummary();
    }

    public List<CucumberFeature> getFeatures() {
        return this.runtimeOptions.cucumberFeatures(this.resourceLoader);
    }

    public Object[][] provideFeatures() {
        try {
            List<CucumberFeature> features = this.getFeatures();
            ArrayList<Object[]> featuresList = new ArrayList<Object[]>(features.size());
            for (CucumberFeature feature : features) {
                featuresList.add(new Object[]{new CucumberFeatureWrapperImpl(feature)});
            }
            return (Object[][])featuresList.toArray((T[])new Object[0][]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e)}};
        }
    }
}

