/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class CucumberTestContext {
    public static final String SCOPE_CUCUMBER_GLUE = "cucumber-glue";
    private static final ThreadLocal<CucumberTestContext> localContext = ThreadLocal.withInitial(CucumberTestContext::new);
    private static final AtomicInteger sessionCounter = new AtomicInteger(0);
    private final Map<String, Object> objects = new HashMap<String, Object>();
    private final Map<String, Runnable> callbacks = new HashMap<String, Runnable>();
    private Integer sessionId;

    private CucumberTestContext() {
    }

    static CucumberTestContext getInstance() {
        return localContext.get();
    }

    void start() {
        this.sessionId = sessionCounter.incrementAndGet();
    }

    Optional<Integer> getId() {
        return Optional.ofNullable(this.sessionId);
    }

    void stop() {
        for (Runnable callback : this.callbacks.values()) {
            callback.run();
        }
        localContext.remove();
        this.sessionId = null;
    }

    Object get(String name) {
        this.requireActiveScenario();
        return this.objects.get(name);
    }

    void put(String name, Object object) {
        this.requireActiveScenario();
        this.objects.put(name, object);
    }

    Object remove(String name) {
        this.requireActiveScenario();
        this.callbacks.remove(name);
        return this.objects.remove(name);
    }

    void registerDestructionCallback(String name, Runnable callback) {
        this.requireActiveScenario();
        this.callbacks.put(name, callback);
    }

    void requireActiveScenario() {
        if (this.sessionId == null) {
            throw new IllegalStateException("Scenario scoped beans can only be created while Cucumber is executing a scenario");
        }
    }
}

