/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.spring;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.spring.GlueCodeScope;
import java.util.Collection;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;

abstract class TestContextAdaptor {
    protected final ConfigurableApplicationContext applicationContext;
    private final Collection<Class<?>> glueClasses;

    protected TestContextAdaptor(ConfigurableApplicationContext applicationContext, Collection<Class<?>> glueClasses) {
        this.applicationContext = applicationContext;
        this.glueClasses = glueClasses;
    }

    static TestContextAdaptor createTestContextManagerAdaptor(TestContextManager delegate, Collection<Class<?>> glueClasses) {
        TestContext testContext = delegate.getTestContext();
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
        return new TestContextManagerAdaptor(delegate, applicationContext, glueClasses);
    }

    static TestContextAdaptor createApplicationContextAdaptor(ConfigurableApplicationContext applicationContext, Collection<Class<?>> glueClasses) {
        return new FallbackApplicationContextAdaptor(applicationContext, glueClasses);
    }

    abstract void start();

    abstract void stop();

    final <T> T getInstance(Class<T> type) {
        return (T)this.applicationContext.getBean(type);
    }

    final void registerGlueCodeScope(ConfigurableApplicationContext context) {
        while (context != null) {
            context.getBeanFactory().registerScope("cucumber-glue", (Scope)new GlueCodeScope());
            context = (ConfigurableApplicationContext)context.getParent();
        }
    }

    final void registerStepClassBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (Class<?> glue : this.glueClasses) {
            this.registerStepClassBeanDefinition(registry, glue);
        }
    }

    private void registerStepClassBeanDefinition(BeanDefinitionRegistry registry, Class<?> glueClass) {
        String beanName = glueClass.getName();
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(glueClass).setScope("cucumber-glue").getBeanDefinition());
    }

    private static final class FallbackApplicationContextAdaptor
    extends TestContextAdaptor {
        FallbackApplicationContextAdaptor(ConfigurableApplicationContext applicationContext, Collection<Class<?>> glueClasses) {
            super(applicationContext, glueClasses);
        }

        @Override
        public void start() {
            this.applicationContext.registerShutdownHook();
            this.applicationContext.refresh();
            this.registerGlueCodeScope(this.applicationContext);
            this.registerStepClassBeanDefinitions(this.applicationContext.getBeanFactory());
        }

        @Override
        public void stop() {
        }
    }

    private static final class TestContextManagerAdaptor
    extends TestContextAdaptor {
        private static final Object monitor = new Object();
        private final TestContextManager delegate;

        private TestContextManagerAdaptor(TestContextManager delegate, ConfigurableApplicationContext applicationContext, Collection<Class<?>> glueClasses) {
            super(applicationContext, glueClasses);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            Object object = monitor;
            synchronized (object) {
                this.registerGlueCodeScope(this.applicationContext);
                this.notifyContextManagerAboutTestClassStarted();
                this.registerStepClassBeanDefinitions(this.applicationContext.getBeanFactory());
            }
        }

        private void notifyContextManagerAboutTestClassStarted() {
            try {
                this.delegate.beforeTestClass();
            }
            catch (Exception e) {
                throw new CucumberBackendException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void stop() {
            try {
                this.delegate.afterTestClass();
            }
            catch (Exception e) {
                throw new CucumberBackendException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

