/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.spring;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.SimpleTransactionStatus;

public class SpringTransactionHooks
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private String txnManagerBeanName;
    private TransactionStatus transactionStatus;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public String getTxnManagerBeanName() {
        return this.txnManagerBeanName;
    }

    public void setTxnManagerBeanName(String txnManagerBeanName) {
        this.txnManagerBeanName = txnManagerBeanName;
    }

    @Before(value={"@txn"}, order=100)
    public void startTransaction() {
        this.transactionStatus = this.obtainPlatformTransactionManager().getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
    }

    @After(value={"@txn"}, order=100)
    public void rollBackTransaction() {
        this.obtainPlatformTransactionManager().rollback(this.transactionStatus);
    }

    public PlatformTransactionManager obtainPlatformTransactionManager() {
        if (this.getTxnManagerBeanName() == null) {
            return (PlatformTransactionManager)this.beanFactory.getBean(PlatformTransactionManager.class);
        }
        return (PlatformTransactionManager)this.beanFactory.getBean(this.txnManagerBeanName, PlatformTransactionManager.class);
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(SimpleTransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }
}

