/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.plugin.event;

import io.cucumber.plugin.event.TimeStampedEvent;
import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class SnippetsSuggestedEvent
extends TimeStampedEvent {
    private final URI uri;
    private final int scenarioLine;
    private final int stepLine;
    private final List<String> snippets;

    public SnippetsSuggestedEvent(Instant timeInstant, URI uri, int scenarioLine, int stepLine, List<String> snippets) {
        super(timeInstant);
        this.uri = Objects.requireNonNull(uri);
        this.scenarioLine = scenarioLine;
        this.stepLine = stepLine;
        this.snippets = Collections.unmodifiableList(Objects.requireNonNull(snippets));
    }

    public URI getUri() {
        return this.uri;
    }

    public int getStepLine() {
        return this.stepLine;
    }

    public int getScenarioLine() {
        return this.scenarioLine;
    }

    public List<String> getSnippets() {
        return this.snippets;
    }
}

