/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.junit.platform.engine.Cucumber;
import io.cucumber.junit.platform.engine.CucumberEngineDescriptor;
import io.cucumber.junit.platform.engine.CucumberEngineOptions;
import io.cucumber.junit.platform.engine.FeatureDescriptor;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import io.cucumber.junit.platform.engine.NamingStrategy;
import io.cucumber.junit.platform.engine.NodeDescriptor;
import io.cucumber.junit.platform.engine.PickleDescriptor;
import io.cucumber.junit.platform.engine.TestDescriptorOnLine;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

final class FeatureResolver {
    private static final Logger log = LoggerFactory.getLogger(FeatureResolver.class);
    private final FeatureParser featureParser = new FeatureParser(UUID::randomUUID);
    private final ResourceScanner<Feature> featureScanner = new ResourceScanner(ClassLoaders::getDefaultClassLoader, FeatureIdentifier::isFeature, arg_0 -> ((FeatureParser)this.featureParser).parseResource(arg_0));
    private final CucumberEngineDescriptor engineDescriptor;
    private final Predicate<String> packageFilter;
    private final ConfigurationParameters parameters;
    private final NamingStrategy namingStrategy;

    private FeatureResolver(ConfigurationParameters parameters, CucumberEngineDescriptor engineDescriptor, Predicate<String> packageFilter) {
        this.parameters = parameters;
        this.engineDescriptor = engineDescriptor;
        this.packageFilter = packageFilter;
        this.namingStrategy = new CucumberEngineOptions(parameters).namingStrategy();
    }

    static FeatureResolver create(ConfigurationParameters parameters, CucumberEngineDescriptor engineDescriptor, Predicate<String> packageFilter) {
        return new FeatureResolver(parameters, engineDescriptor, packageFilter);
    }

    void resolveFile(FileSelector selector) {
        this.featureScanner.scanForResourcesPath(selector.getPath()).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(featureDescriptor -> {
            featureDescriptor.prune(TestDescriptorOnLine.from(selector));
            this.engineDescriptor.mergeFeature((FeatureDescriptor)((Object)featureDescriptor));
        });
    }

    private FeatureDescriptor createFeatureDescriptor(Feature feature) {
        FeatureOrigin source = FeatureOrigin.fromUri(feature.getUri());
        return (FeatureDescriptor)((Object)feature.map((Object)this.engineDescriptor, (self, parent) -> new FeatureDescriptor(source.featureSegment(parent.getUniqueId(), feature), this.namingStrategy.name((Node)self), source.featureSource(), feature), (node, parent) -> {
            NodeDescriptor descriptor = new NodeDescriptor(source.ruleSegment(parent.getUniqueId(), (Node)node), this.namingStrategy.name((Node)node), source.nodeSource((Node)node));
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            Pickle pickle = feature.getPickleAt((Node)node);
            PickleDescriptor descriptor = new PickleDescriptor(this.parameters, source.scenarioSegment(parent.getUniqueId(), (Node)node), this.namingStrategy.name((Node)node), source.nodeSource((Node)node), pickle);
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            NodeDescriptor descriptor = new NodeDescriptor(source.scenarioSegment(parent.getUniqueId(), (Node)node), this.namingStrategy.name((Node)node), source.nodeSource((Node)node));
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            NodeDescriptor descriptor = new NodeDescriptor(source.examplesSegment(parent.getUniqueId(), (Node)node), this.namingStrategy.name((Node)node), source.nodeSource((Node)node));
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            Pickle pickle = feature.getPickleAt((Node)node);
            PickleDescriptor descriptor = new PickleDescriptor(this.parameters, source.exampleSegment(parent.getUniqueId(), (Node)node), this.namingStrategy.name((Node)node), source.nodeSource((Node)node), pickle);
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }));
    }

    void resolveDirectory(DirectorySelector selector) {
        this.featureScanner.scanForResourcesPath(selector.getPath()).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(this.engineDescriptor::mergeFeature);
    }

    void resolvePackageResource(PackageSelector selector) {
        this.resolvePackageResource(selector.getPackageName());
    }

    private List<Feature> resolvePackageResource(String packageName) {
        List features = this.featureScanner.scanForResourcesInPackage(packageName, this.packageFilter);
        features.stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(this.engineDescriptor::mergeFeature);
        return features;
    }

    void resolveClass(ClassSelector classSelector) {
        Class javaClass = classSelector.getJavaClass();
        Cucumber annotation = javaClass.getAnnotation(Cucumber.class);
        if (annotation != null) {
            this.resolvePackageResourceWarnIfNone(javaClass.getPackage().getName());
        }
    }

    private void resolvePackageResourceWarnIfNone(String packageName) {
        List<Feature> features = this.resolvePackageResource(packageName);
        if (features.isEmpty()) {
            log.warn(() -> "No features found in package '" + packageName + "'");
        }
    }

    void resolveClasspathResource(ClasspathResourceSelector selector) {
        String classpathResourceName = selector.getClasspathResourceName();
        this.featureScanner.scanForClasspathResource(classpathResourceName, this.packageFilter).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(featureDescriptor -> {
            featureDescriptor.prune(TestDescriptorOnLine.from(selector));
            this.engineDescriptor.mergeFeature((FeatureDescriptor)((Object)featureDescriptor));
        });
    }

    void resolveClasspathRoot(ClasspathRootSelector selector) {
        this.featureScanner.scanForResourcesInClasspathRoot(selector.getClasspathRoot(), this.packageFilter).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(this.engineDescriptor::mergeFeature);
    }

    void resolveUniqueId(UniqueIdSelector uniqueIdSelector) {
        UniqueId uniqueId = uniqueIdSelector.getUniqueId();
        if (!uniqueId.hasPrefix(this.engineDescriptor.getUniqueId())) {
            return;
        }
        Predicate<TestDescriptor> keepTestWithSelectedId = testDescriptor -> uniqueId.equals((Object)testDescriptor.getUniqueId());
        uniqueId.getSegments().stream().filter(FeatureOrigin::isFeatureSegment).map(UniqueId.Segment::getValue).map(URI::create).flatMap(this::resolveUri).forEach(featureDescriptor -> {
            featureDescriptor.prune(keepTestWithSelectedId);
            this.engineDescriptor.mergeFeature((FeatureDescriptor)((Object)featureDescriptor));
        });
    }

    private Stream<FeatureDescriptor> resolveUri(URI uri) {
        return this.featureScanner.scanForResourcesUri(uri).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor);
    }

    void resolveUri(UriSelector selector) {
        this.resolveUri(FeatureResolver.stripQuery(selector.getUri())).forEach(featureDescriptor -> {
            featureDescriptor.prune(TestDescriptorOnLine.from(selector));
            this.engineDescriptor.mergeFeature((FeatureDescriptor)((Object)featureDescriptor));
        });
    }

    void resolveFeatureWithLines(FeatureWithLines selector) {
        this.resolveUri(selector.uri()).forEach(featureDescriptor -> {
            featureDescriptor.prune(TestDescriptorOnLine.from(selector));
            this.engineDescriptor.mergeFeature((FeatureDescriptor)((Object)featureDescriptor));
        });
    }

    private static URI stripQuery(URI uri) {
        if (uri.getQuery() == null) {
            return uri;
        }
        String uriString = uri.toString();
        return URI.create(uriString.substring(0, uriString.indexOf(63)));
    }
}

