/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.resource.PathScanner;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Predicate;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class FileContainerSelectorResolver
implements SelectorResolver {
    private final PathScanner pathScanner = new PathScanner();
    private final Predicate<Path> filter;

    FileContainerSelectorResolver(Predicate<Path> filter) {
        this.filter = filter;
    }

    public SelectorResolver.Resolution resolve(DirectorySelector selector, SelectorResolver.Context context) {
        HashSet selectors = new HashSet();
        this.pathScanner.findResourcesForPath(selector.getPath(), this.filter, path -> selectors.add(DiscoverySelectors.selectFile((File)path.toFile())));
        if (selectors.isEmpty()) {
            return SelectorResolver.Resolution.unresolved();
        }
        return SelectorResolver.Resolution.selectors(selectors);
    }
}

