/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.io.File;
import java.net.URI;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.UriSource;

abstract class FeatureOrigin {
    static final String RULE_SEGMENT_TYPE = "rule";
    static final String FEATURE_SEGMENT_TYPE = "feature";
    static final String SCENARIO_SEGMENT_TYPE = "scenario";
    static final String EXAMPLES_SEGMENT_TYPE = "examples";
    static final String EXAMPLE_SEGMENT_TYPE = "example";

    FeatureOrigin() {
    }

    private static FilePosition createFilePosition(Location location) {
        return FilePosition.from((int)location.getLine(), (int)location.getColumn());
    }

    static FeatureOrigin fromUri(URI uri) {
        if ("classpath".equals(uri.getScheme())) {
            if (!uri.getSchemeSpecificPart().startsWith("/")) {
                uri = URI.create("classpath:/" + uri.getRawSchemeSpecificPart());
            }
            ClasspathResourceSource source = ClasspathResourceSource.from((URI)uri);
            return new ClasspathFeatureOrigin(source);
        }
        UriSource source = UriSource.from((URI)uri);
        if (source instanceof FileSource) {
            return new FileFeatureOrigin((FileSource)source);
        }
        return new UriFeatureOrigin(source);
    }

    static boolean isFeatureSegment(UniqueId.Segment segment) {
        return FEATURE_SEGMENT_TYPE.equals(segment.getType());
    }

    abstract TestSource nodeSource(Node var1);

    abstract TestSource source();

    private static class ClasspathFeatureOrigin
    extends FeatureOrigin {
        private final ClasspathResourceSource source;

        ClasspathFeatureOrigin(ClasspathResourceSource source) {
            this.source = source;
        }

        @Override
        TestSource nodeSource(Node node) {
            return ClasspathResourceSource.from((String)this.source.getClasspathResourceName(), (FilePosition)FeatureOrigin.createFilePosition(node.getLocation()));
        }

        @Override
        TestSource source() {
            return this.source;
        }
    }

    private static class FileFeatureOrigin
    extends FeatureOrigin {
        private final FileSource source;

        FileFeatureOrigin(FileSource source) {
            this.source = source;
        }

        @Override
        TestSource nodeSource(Node node) {
            return FileSource.from((File)this.source.getFile(), (FilePosition)FeatureOrigin.createFilePosition(node.getLocation()));
        }

        @Override
        TestSource source() {
            return this.source;
        }
    }

    private static class UriFeatureOrigin
    extends FeatureOrigin {
        private final UriSource source;

        UriFeatureOrigin(UriSource source) {
            this.source = source;
        }

        @Override
        TestSource nodeSource(Node node) {
            return this.source;
        }

        @Override
        TestSource source() {
            return this.source;
        }
    }
}

