/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.gherkin.Pickle;
import io.cucumber.junit.platform.engine.NamingStrategy;
import io.cucumber.plugin.event.Node;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.platform.engine.ConfigurationParameters;

enum DefaultNamingStrategyProvider {
    LONG{

        @Override
        NamingStrategy create(ConfigurationParameters configuration) {
            return configuration.get("cucumber.junit-platform.naming-strategy.long.example-name").map(x$0 -> DefaultNamingStrategyProvider.parseStrategy(x$0)).orElse(x$0 -> DefaultNamingStrategyProvider.exampleNumberStrategy(x$0)).apply((x$0, x$1) -> DefaultNamingStrategyProvider.longStrategy(x$0, x$1));
        }
    }
    ,
    SHORT{

        @Override
        NamingStrategy create(ConfigurationParameters configuration) {
            return configuration.get("cucumber.junit-platform.naming-strategy.short.example-name").map(x$0 -> DefaultNamingStrategyProvider.parseStrategy(x$0)).orElse(x$0 -> DefaultNamingStrategyProvider.exampleNumberStrategy(x$0)).apply((x$0, x$1) -> DefaultNamingStrategyProvider.shortStrategy(x$0, x$1));
        }
    };


    abstract NamingStrategy create(ConfigurationParameters var1);

    static DefaultNamingStrategyProvider getStrategyProvider(String name) {
        return DefaultNamingStrategyProvider.valueOf(name.toUpperCase(Locale.ROOT));
    }

    private static Function<BiFunction<Node, String, String>, NamingStrategy> parseStrategy(String exampleStrategy) {
        switch (exampleStrategy) {
            case "number": {
                return DefaultNamingStrategyProvider::exampleNumberStrategy;
            }
            case "pickle": {
                return DefaultNamingStrategyProvider::pickleNameStrategy;
            }
        }
        throw new IllegalArgumentException("Unrecognized example naming strategy " + exampleStrategy);
    }

    private static NamingStrategy exampleNumberStrategy(BiFunction<Node, String, String> baseStrategy) {
        return DefaultNamingStrategyProvider.createNamingStrategy(node -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node)), (node, pickle) -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node)));
    }

    private static NamingStrategy pickleNameStrategy(BiFunction<Node, String, String> baseStrategy) {
        return DefaultNamingStrategyProvider.createNamingStrategy(node -> (String)baseStrategy.apply((Node)node, DefaultNamingStrategyProvider.nameOrKeyword(node)), (node, pickle) -> (String)baseStrategy.apply((Node)node, pickle.getName()));
    }

    private static NamingStrategy createNamingStrategy(final Function<Node, String> nameFunction, final BiFunction<Node, Pickle, String> exampleNameFunction) {
        return new NamingStrategy(){

            @Override
            public String name(Node node) {
                return (String)nameFunction.apply(node);
            }

            @Override
            public String nameExample(Node.Example node, Pickle pickle) {
                return (String)exampleNameFunction.apply(node, pickle);
            }
        };
    }

    private static String nameOrKeyword(Node node) {
        Supplier<String> keyword = () -> node.getKeyword().orElse("Unknown");
        return node.getName().orElseGet(keyword);
    }

    private static String shortStrategy(Node node, String currentNodeName) {
        return currentNodeName;
    }

    private static String longStrategy(Node node, String currentNodeName) {
        StringBuilder builder = new StringBuilder();
        builder.append(currentNodeName);
        node = node.getParent().orElse(null);
        while (node != null) {
            builder.insert(0, " - ");
            builder.insert(0, DefaultNamingStrategyProvider.nameOrKeyword(node));
            node = node.getParent().orElse(null);
        }
        return builder.toString();
    }
}

