/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.CucumberEngineExecutionContext;
import io.cucumber.junit.platform.engine.FeatureDescriptor;
import java.util.Optional;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

class CucumberEngineDescriptor
extends EngineDescriptor
implements Node<CucumberEngineExecutionContext> {
    static final String ENGINE_ID = "cucumber";

    CucumberEngineDescriptor(UniqueId uniqueId) {
        super(uniqueId, "Cucumber");
    }

    private static void recursivelyMerge(TestDescriptor descriptor, TestDescriptor parent) {
        Optional byUniqueId = parent.findByUniqueId(descriptor.getUniqueId());
        if (!byUniqueId.isPresent()) {
            parent.addChild(descriptor);
        } else {
            byUniqueId.ifPresent(existingParent -> descriptor.getChildren().forEach(child -> CucumberEngineDescriptor.recursivelyMerge(child, existingParent)));
        }
    }

    public CucumberEngineExecutionContext prepare(CucumberEngineExecutionContext context) {
        if (this.getChildren().isEmpty()) {
            return context;
        }
        context.startTestRun();
        return context;
    }

    public CucumberEngineExecutionContext before(CucumberEngineExecutionContext context) {
        if (this.getChildren().isEmpty()) {
            return context;
        }
        context.runBeforeAllHooks();
        return context;
    }

    public void after(CucumberEngineExecutionContext context) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        context.runAfterAllHooks();
    }

    public void cleanUp(CucumberEngineExecutionContext context) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        context.finishTestRun();
    }

    void mergeFeature(FeatureDescriptor descriptor) {
        CucumberEngineDescriptor.recursivelyMerge((TestDescriptor)descriptor, (TestDescriptor)this);
    }
}

