/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.FeatureIdentifier;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.resource.ClassLoaders;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.junit.platform.engine.Cucumber;
import io.cucumber.junit.platform.engine.CucumberEngineDescriptor;
import io.cucumber.junit.platform.engine.FeatureDescriptor;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import io.cucumber.junit.platform.engine.NodeDescriptor;
import io.cucumber.junit.platform.engine.PickleDescriptor;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSource;

final class FeatureResolver {
    private final FeatureParser featureParser = new FeatureParser(UUID::randomUUID);
    private final ResourceScanner<Feature> featureScanner = new ResourceScanner(ClassLoaders::getDefaultClassLoader, FeatureIdentifier::isFeature, arg_0 -> ((FeatureParser)this.featureParser).parseResource(arg_0));
    private final CucumberEngineDescriptor engineDescriptor;
    private final Predicate<String> packageFilter;
    private final ConfigurationParameters parameters;

    private FeatureResolver(ConfigurationParameters parameters, CucumberEngineDescriptor engineDescriptor, Predicate<String> packageFilter) {
        this.parameters = parameters;
        this.engineDescriptor = engineDescriptor;
        this.packageFilter = packageFilter;
    }

    static FeatureResolver createFeatureResolver(ConfigurationParameters parameters, CucumberEngineDescriptor engineDescriptor, Predicate<String> packageFilter) {
        return new FeatureResolver(parameters, engineDescriptor, packageFilter);
    }

    private static URI stripQuery(URI uri) {
        if (uri.getQuery() == null) {
            return uri;
        }
        String uriString = uri.toString();
        return URI.create(uriString.substring(0, uriString.indexOf(63)));
    }

    private static Predicate<TestDescriptor> testDescriptorOnLine(Integer line) {
        return descriptor -> descriptor.getSource().flatMap(testSource -> {
            if (testSource instanceof FileSource) {
                FileSource fileSystemSource = (FileSource)testSource;
                return fileSystemSource.getPosition();
            }
            if (testSource instanceof ClasspathResourceSource) {
                ClasspathResourceSource classpathResourceSource = (ClasspathResourceSource)testSource;
                return classpathResourceSource.getPosition();
            }
            return Optional.empty();
        }).map(FilePosition::getLine).map(line::equals).orElse(false);
    }

    void resolveFile(FileSelector selector) {
        this.resolvePath(selector.getPath());
    }

    void resolveDirectory(DirectorySelector selector) {
        this.resolvePath(selector.getPath());
    }

    private void resolvePath(Path path) {
        this.featureScanner.scanForResourcesPath(path).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(this.engineDescriptor::mergeFeature);
    }

    void resolvePackageResource(PackageSelector selector) {
        this.resolvePackageResource(selector.getPackageName());
    }

    void resolveClass(ClassSelector classSelector) {
        Class javaClass = classSelector.getJavaClass();
        Cucumber annotation = javaClass.getAnnotation(Cucumber.class);
        if (annotation != null) {
            this.resolvePackageResource(javaClass.getPackage().getName());
        }
    }

    private void resolvePackageResource(String packageName) {
        this.featureScanner.scanForResourcesInPackage(packageName, this.packageFilter).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(this.engineDescriptor::mergeFeature);
    }

    void resolveClasspathResource(ClasspathResourceSelector selector) {
        String classpathResourceName = selector.getClasspathResourceName();
        this.featureScanner.scanForClasspathResource(classpathResourceName, this.packageFilter).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(this.engineDescriptor::mergeFeature);
    }

    void resolveClasspathRoot(ClasspathRootSelector selector) {
        this.featureScanner.scanForResourcesInClasspathRoot(selector.getClasspathRoot(), this.packageFilter).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor).forEach(this.engineDescriptor::mergeFeature);
    }

    void resolveUniqueId(UniqueIdSelector uniqueIdSelector) {
        UniqueId uniqueId = uniqueIdSelector.getUniqueId();
        if (!this.engineDescriptor.getUniqueId().getEngineId().equals(uniqueId.getEngineId())) {
            return;
        }
        Predicate<TestDescriptor> keepTestWithSelectedId = testDescriptor -> uniqueId.equals((Object)testDescriptor.getUniqueId());
        uniqueId.getSegments().stream().filter(FeatureOrigin::isFeatureSegment).map(UniqueId.Segment::getValue).map(URI::create).flatMap(this::resolveUri).forEach(featureDescriptor -> {
            featureDescriptor.prune(keepTestWithSelectedId);
            this.engineDescriptor.mergeFeature((FeatureDescriptor)((Object)featureDescriptor));
        });
    }

    void resolveUri(UriSelector selector) {
        URI uri = selector.getUri();
        Predicate<TestDescriptor> keepTestOnSelectedLine = FilePosition.fromQuery((String)uri.getQuery()).map(FilePosition::getLine).map(FeatureResolver::testDescriptorOnLine).orElse(testDescriptor -> true);
        this.resolveUri(FeatureResolver.stripQuery(uri)).forEach(featureDescriptor -> {
            featureDescriptor.prune(keepTestOnSelectedLine);
            this.engineDescriptor.mergeFeature((FeatureDescriptor)((Object)featureDescriptor));
        });
    }

    private Stream<FeatureDescriptor> resolveUri(URI uri) {
        return this.featureScanner.scanForResourcesUri(uri).stream().sorted(Comparator.comparing(Feature::getUri)).map(this::createFeatureDescriptor);
    }

    private FeatureDescriptor createFeatureDescriptor(Feature feature) {
        FeatureOrigin source = FeatureOrigin.fromUri(feature.getUri());
        return (FeatureDescriptor)((Object)feature.map((Object)this.engineDescriptor, (self, parent) -> new FeatureDescriptor(source.featureSegment(parent.getUniqueId(), feature), this.getNameOrKeyWord((Node)self), source.featureSource(), feature), (node, parent) -> {
            NodeDescriptor descriptor = new NodeDescriptor(source.ruleSegment(parent.getUniqueId(), (Node)node), this.getNameOrKeyWord((Node)node), source.nodeSource((Node)node));
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            Pickle pickle = feature.getPickleAt((Node)node);
            PickleDescriptor descriptor = new PickleDescriptor(this.parameters, source.scenarioSegment(parent.getUniqueId(), (Node)node), this.getNameOrKeyWord((Node)node), source.nodeSource((Node)node), pickle);
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            NodeDescriptor descriptor = new NodeDescriptor(source.scenarioSegment(parent.getUniqueId(), (Node)node), this.getNameOrKeyWord((Node)node), source.nodeSource((Node)node));
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            NodeDescriptor descriptor = new NodeDescriptor(source.examplesSegment(parent.getUniqueId(), (Node)node), this.getNameOrKeyWord((Node)node), source.nodeSource((Node)node));
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }, (node, parent) -> {
            Pickle pickle = feature.getPickleAt((Node)node);
            PickleDescriptor descriptor = new PickleDescriptor(this.parameters, source.exampleSegment(parent.getUniqueId(), (Node)node), this.getNameOrKeyWord((Node)node), source.nodeSource((Node)node), pickle);
            parent.addChild((TestDescriptor)descriptor);
            return descriptor;
        }));
    }

    private String getNameOrKeyWord(Node node) {
        Supplier<String> keyword = () -> node.getKeyword().orElse("Unknown");
        return node.getName().orElseGet(keyword);
    }
}

