package io.cucumber.java8;

import io.cucumber.java8.StepDefinitionBody.A0;
import io.cucumber.java8.StepDefinitionBody.A1;
import io.cucumber.java8.StepDefinitionBody.A2;
import io.cucumber.java8.StepDefinitionBody.A3;
import io.cucumber.java8.StepDefinitionBody.A4;
import io.cucumber.java8.StepDefinitionBody.A5;
import io.cucumber.java8.StepDefinitionBody.A6;
import io.cucumber.java8.StepDefinitionBody.A7;
import io.cucumber.java8.StepDefinitionBody.A8;
import io.cucumber.java8.StepDefinitionBody.A9;

import io.cucumber.java8.LambdaGlueRegistry;
import io.cucumber.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Indonesian - Bahasa Indonesia
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface Id extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Bila(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Bila(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Bila(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Bila(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Bila(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Bila(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Bila(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Bila(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Bila(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Bila(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dan(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Dan(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Dan(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Dan(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Dan(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Dan(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Dan(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dan(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dan(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dan(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dengan(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Dengan(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Dengan(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Dengan(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Dengan(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Dengan(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Dengan(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dengan(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dengan(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dengan(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Diasumsikan(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Diasumsikan(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Diasumsikan(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Diasumsikan(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Diasumsikan(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Diasumsikan(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Diasumsikan(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Diasumsikan(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Diasumsikan(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Diasumsikan(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Diketahui(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Diketahui(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Diketahui(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Diketahui(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Diketahui(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Diketahui(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Diketahui(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Diketahui(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Diketahui(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Diketahui(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Jika(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Jika(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Jika(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Jika(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Jika(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Jika(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Jika(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Jika(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Jika(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Jika(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Kemudian(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Kemudian(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Kemudian(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Kemudian(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Kemudian(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Kemudian(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Kemudian(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Kemudian(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Kemudian(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Kemudian(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ketika(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Ketika(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Ketika(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Ketika(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Ketika(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Ketika(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Ketika(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ketika(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ketika(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ketika(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Maka(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Maka(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Maka(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Maka(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Maka(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Maka(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Maka(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Maka(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Maka(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Maka(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Tapi(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Tapi(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Tapi(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Tapi(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Tapi(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Tapi(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Tapi(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Tapi(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Tapi(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Tapi(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Tetapi(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void Tetapi(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void Tetapi(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void Tetapi(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void Tetapi(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void Tetapi(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void Tetapi(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Tetapi(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Tetapi(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Tetapi(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }

}
