/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.StepDefinition;

interface LambdaGlueRegistry {
    public static final LambdaGlueRegistry CLOSED = new ClosedLambdaGlueRegistry();
    public static final ThreadLocal<LambdaGlueRegistry> INSTANCE = ThreadLocal.withInitial(() -> CLOSED);

    public void addStepDefinition(StepDefinition var1);

    public void addBeforeStepHookDefinition(HookDefinition var1);

    public void addAfterStepHookDefinition(HookDefinition var1);

    public void addBeforeHookDefinition(HookDefinition var1);

    public void addAfterHookDefinition(HookDefinition var1);

    public void addDocStringType(DocStringTypeDefinition var1);

    public void addDataTableType(DataTableTypeDefinition var1);

    public void addParameterType(ParameterTypeDefinition var1);

    public void addDefaultParameterTransformer(DefaultParameterTransformerDefinition var1);

    public void addDefaultDataTableCellTransformer(DefaultDataTableCellTransformerDefinition var1);

    public void addDefaultDataTableEntryTransformer(DefaultDataTableEntryTransformerDefinition var1);

    public static class ClosedLambdaGlueRegistry
    implements LambdaGlueRegistry {
        private static CucumberBackendException createRegistryIsClosedException(Class<?> aClass) {
            return new CucumberBackendException(aClass.getName() + " was initialized either without an active scenario or after a scenario already started execution.");
        }

        @Override
        public void addStepDefinition(StepDefinition stepDefinition) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(stepDefinition.getClass());
        }

        @Override
        public void addBeforeStepHookDefinition(HookDefinition beforeStepHook) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(beforeStepHook.getClass());
        }

        @Override
        public void addAfterStepHookDefinition(HookDefinition afterStepHook) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(afterStepHook.getClass());
        }

        @Override
        public void addBeforeHookDefinition(HookDefinition beforeHook) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(beforeHook.getClass());
        }

        @Override
        public void addAfterHookDefinition(HookDefinition afterHook) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(afterHook.getClass());
        }

        @Override
        public void addDocStringType(DocStringTypeDefinition docStringType) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(docStringType.getClass());
        }

        @Override
        public void addDataTableType(DataTableTypeDefinition dataTableType) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(dataTableType.getClass());
        }

        @Override
        public void addParameterType(ParameterTypeDefinition parameterType) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(parameterType.getClass());
        }

        @Override
        public void addDefaultParameterTransformer(DefaultParameterTransformerDefinition defaultParameterTransformer) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(defaultParameterTransformer.getClass());
        }

        @Override
        public void addDefaultDataTableCellTransformer(DefaultDataTableCellTransformerDefinition defaultDataTableCellTransformer) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(defaultDataTableCellTransformer.getClass());
        }

        @Override
        public void addDefaultDataTableEntryTransformer(DefaultDataTableEntryTransformerDefinition defaultDataTableEntryTransformer) {
            throw ClosedLambdaGlueRegistry.createRegistryIsClosedException(defaultDataTableEntryTransformer.getClass());
        }
    }
}

