package io.cucumber.java8;

import io.cucumber.java8.StepDefinitionBody.A0;
import io.cucumber.java8.StepDefinitionBody.A1;
import io.cucumber.java8.StepDefinitionBody.A2;
import io.cucumber.java8.StepDefinitionBody.A3;
import io.cucumber.java8.StepDefinitionBody.A4;
import io.cucumber.java8.StepDefinitionBody.A5;
import io.cucumber.java8.StepDefinitionBody.A6;
import io.cucumber.java8.StepDefinitionBody.A7;
import io.cucumber.java8.StepDefinitionBody.A8;
import io.cucumber.java8.StepDefinitionBody.A9;

import io.cucumber.java8.LambdaGlueRegistry;
import io.cucumber.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Georgian - ქართული
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface Ka extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void ასევე(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void ასევე(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void ასევე(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void ასევე(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void ასევე(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void ასევე(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void ასევე(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void ასევე(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void ასევე(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void ასევე(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void და(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void და(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void და(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void და(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void და(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void და(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void და(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void და(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void და(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void და(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void ვთქვათ(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void ვთქვათ(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void ვთქვათ(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void ვთქვათ(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void ვთქვათ(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void ვთქვათ(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void ვთქვათ(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void ვთქვათ(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void ვთქვათ(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void ვთქვათ(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void თუ(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void თუ(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void თუ(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void თუ(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void თუ(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void თუ(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void თუ(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void თუ(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void თუ(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void თუ(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void თუმცა(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void თუმცა(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void თუმცა(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void თუმცა(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void თუმცა(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void თუმცა(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void თუმცა(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void თუმცა(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void თუმცა(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void თუმცა(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void მაგრამ(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void მაგრამ(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void მაგრამ(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void მაგრამ(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void მაგრამ(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void მაგრამ(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void მაგრამ(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void მაგრამ(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void მაგრამ(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void მაგრამ(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void მაშინ(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void მაშინ(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void მაშინ(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void მაშინ(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void მაშინ(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void მაშინ(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void მაშინ(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void მაშინ(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void მაშინ(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void მაშინ(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void მოცემული(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void მოცემული(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void მოცემული(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void მოცემული(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void მოცემული(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void მოცემული(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void მოცემული(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void მოცემული(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void მოცემული(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void მოცემული(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void მოცემულია(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void მოცემულია(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void მოცემულია(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void მოცემულია(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void მოცემულია(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void მოცემულია(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void მოცემულია(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void მოცემულია(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void მოცემულია(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void მოცემულია(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void როგორცკი(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void როგორცკი(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void როგორცკი(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void როგორცკი(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void როგორცკი(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void როგორცკი(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void როგორცკი(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void როგორცკი(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void როგორცკი(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void როგორცკი(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void როდესაც(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void როდესაც(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void როდესაც(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void როდესაც(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void როდესაც(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void როდესაც(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void როდესაც(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void როდესაც(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void როდესაც(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void როდესაც(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }


    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void როცა(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A0.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameter
     *
     * @param <T1> type of argument 1
     */
    default <T1> void როცა(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A1.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     */
    default <T1,T2> void როცა(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A2.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     */
    default <T1,T2,T3> void როცა(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A3.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     */
    default <T1,T2,T3,T4> void როცა(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A4.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     */
    default <T1,T2,T3,T4,T5> void როცა(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A5.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     */
    default <T1,T2,T3,T4,T5,T6> void როცა(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A6.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     */
    default <T1,T2,T3,T4,T5,T6,T7> void როცა(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A7.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void როცა(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A8.class, body));
    }

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     *
     * @param <T1> type of argument 1
     * @param <T2> type of argument 2
     * @param <T3> type of argument 3
     * @param <T4> type of argument 4
     * @param <T5> type of argument 5
     * @param <T6> type of argument 6
     * @param <T7> type of argument 7
     * @param <T8> type of argument 8
     * @param <T9> type of argument 9
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void როცა(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition(Java8StepDefinition.create(expression, A9.class, body));
    }

}
