package io.cucumber.java8;

import io.cucumber.java8.StepdefBody.A0;
import io.cucumber.java8.StepdefBody.A1;
import io.cucumber.java8.StepdefBody.A2;
import io.cucumber.java8.StepdefBody.A3;
import io.cucumber.java8.StepdefBody.A4;
import io.cucumber.java8.StepdefBody.A5;
import io.cucumber.java8.StepdefBody.A6;
import io.cucumber.java8.StepdefBody.A7;
import io.cucumber.java8.StepdefBody.A8;
import io.cucumber.java8.StepdefBody.A9;

import cucumber.runtime.java.LambdaGlueRegistry;
import cucumber.runtime.java8.Java8StepDefinition;
import io.cucumber.java8.LambdaGlue;

import org.apiguardian.api.API;

/**
 * Slovenian
 * <p>
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the the
 * type of last argument.
 */
@API(status = API.Status.STABLE)
public interface Sl extends LambdaGlue {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ampak(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Ampak(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Ampak(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Ampak(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Ampak(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Ampak(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Ampak(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Ampak(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Ampak(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Ampak(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Ampak(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Ampak(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Ampak(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Ampak(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ampak(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Ampak(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ampak(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ampak(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ampak(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ampak(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ce(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Ce(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Ce(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Ce(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Ce(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Ce(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Ce(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Ce(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Ce(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Ce(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Ce(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Ce(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Ce(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Ce(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ce(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Ce(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ce(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ce(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ce(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ce(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Dano(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Dano(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Dano(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Dano(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Dano(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Dano(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Dano(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Dano(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Dano(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Dano(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Dano(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Dano(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Dano(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Dano(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Dano(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Dano(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dano(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Dano(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dano(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Dano(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void In(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void In(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void In(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void In(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void In(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void In(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void In(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void In(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void In(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void In(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void In(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void In(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void In(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void In(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void In(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void In(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void In(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void In(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void In(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void In(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Kadar(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Kadar(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Kadar(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Kadar(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Kadar(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Kadar(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Kadar(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Kadar(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Kadar(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Kadar(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Kadar(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Kadar(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Kadar(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Kadar(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Kadar(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Kadar(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Kadar(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Kadar(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Kadar(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Kadar(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ko(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Ko(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Ko(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Ko(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Ko(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Ko(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Ko(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Ko(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Ko(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Ko(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Ko(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Ko(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Ko(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Ko(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ko(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Ko(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ko(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ko(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ko(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ko(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nato(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Nato(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Nato(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Nato(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Nato(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Nato(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Nato(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Nato(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Nato(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Nato(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Nato(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Nato(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Nato(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Nato(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nato(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Nato(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nato(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nato(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nato(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nato(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Podano(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Podano(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Podano(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Podano(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Podano(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Podano(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Podano(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Podano(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Podano(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Podano(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Podano(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Podano(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Podano(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Podano(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Podano(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Podano(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Podano(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Podano(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Podano(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Podano(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Potem(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Potem(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Potem(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Potem(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Potem(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Potem(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Potem(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Potem(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Potem(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Potem(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Potem(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Potem(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Potem(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Potem(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Potem(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Potem(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Potem(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Potem(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Potem(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Potem(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Privzeto(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Privzeto(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Privzeto(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Privzeto(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Privzeto(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Privzeto(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Privzeto(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Privzeto(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Privzeto(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Privzeto(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Privzeto(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Privzeto(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Privzeto(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Privzeto(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Privzeto(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Privzeto(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Privzeto(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Privzeto(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Privzeto(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Privzeto(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Takrat(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Takrat(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Takrat(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Takrat(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Takrat(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Takrat(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Takrat(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Takrat(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Takrat(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Takrat(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Takrat(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Takrat(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Takrat(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Takrat(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Takrat(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Takrat(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Takrat(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Takrat(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Takrat(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Takrat(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ter(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Ter(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Ter(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Ter(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Ter(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Ter(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Ter(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Ter(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Ter(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Ter(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Ter(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Ter(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Ter(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Ter(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ter(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Ter(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ter(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ter(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ter(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ter(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Toda(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Toda(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Toda(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Toda(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Toda(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Toda(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Toda(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Toda(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Toda(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Toda(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Toda(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Toda(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Toda(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Toda(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Toda(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Toda(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Toda(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Toda(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Toda(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Toda(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Vendar(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Vendar(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Vendar(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Vendar(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Vendar(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Vendar(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Vendar(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Vendar(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Vendar(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Vendar(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Vendar(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Vendar(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Vendar(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Vendar(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Vendar(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Vendar(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Vendar(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Vendar(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Vendar(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Vendar(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Zaradi(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Zaradi(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Zaradi(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Zaradi(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Zaradi(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Zaradi(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Zaradi(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Zaradi(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Zaradi(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Zaradi(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Zaradi(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Zaradi(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Zaradi(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Zaradi(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Zaradi(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Zaradi(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Zaradi(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Zaradi(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Zaradi(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Zaradi(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Če(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default void Če(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     */
    default <T1> void Če(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     * 
     * @param <T1> type of argument 1 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1> void Če(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     */
    default <T1,T2> void Če(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2> void Če(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     */
    default <T1,T2,T3> void Če(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3> void Če(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     */
    default <T1,T2,T3,T4> void Če(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4> void Če(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     */
    default <T1,T2,T3,T4,T5> void Če(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5> void Če(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     */
    default <T1,T2,T3,T4,T5,T6> void Če(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6> void Če(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Če(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7> void Če(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Če(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Če(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

    
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Če(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * The timeout controls how long step is allowed to run. Cucumber
     * will mark the step as failed when exceeded. When the maximum
     * duration is exceeded the thread will receive an in interrupt.
     * Note: if the interrupt is ignored cucumber will wait for the this
     * step to finish.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis timeout in milliseconds. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     * 
     * @param <T1> type of argument 1 
     * @param <T2> type of argument 2 
     * @param <T3> type of argument 3 
     * @param <T4> type of argument 4 
     * @param <T5> type of argument 5 
     * @param <T6> type of argument 6 
     * @param <T7> type of argument 7 
     * @param <T8> type of argument 8 
     * @param <T9> type of argument 9 
     * @deprecated use a library based solution instead. E.g. Awaitility
     * or JUnit 5s Assertions.assertTimeout.
     */
    @Deprecated
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Če(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

}
