/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java8;

import cucumber.api.java8.StepdefBody;
import cucumber.runtime.CucumberException;
import cucumber.runtime.ScenarioScoped;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.java8.ParameterInfo;
import gherkin.pickles.PickleStep;
import io.cucumber.stepexpression.Argument;
import io.cucumber.stepexpression.ExpressionArgumentMatcher;
import io.cucumber.stepexpression.StepExpression;
import io.cucumber.stepexpression.StepExpressionFactory;
import io.cucumber.stepexpression.TypeRegistry;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jodah.typetools.TypeResolver;

public class Java8StepDefinition
implements StepDefinition,
ScenarioScoped {
    private final long timeoutMillis;
    private StepdefBody body;
    private final StepExpression expression;
    private final StackTraceElement location;
    private final List<ParameterInfo> parameterInfos;
    private final Method method;

    public static <T extends StepdefBody> Java8StepDefinition create(String expression, Class<T> bodyClass, T body, TypeRegistry typeRegistry) {
        return new Java8StepDefinition(expression, 0L, bodyClass, body, typeRegistry);
    }

    public static <T extends StepdefBody> StepDefinition create(String expression, long timeoutMillis, Class<T> bodyClass, T body, TypeRegistry typeRegistry) {
        return new Java8StepDefinition(expression, timeoutMillis, bodyClass, body, typeRegistry);
    }

    private <T extends StepdefBody> Java8StepDefinition(String expression, long timeoutMillis, Class<T> bodyClass, T body, TypeRegistry typeRegistry) {
        this.timeoutMillis = timeoutMillis;
        this.body = body;
        this.location = new Exception().getStackTrace()[5];
        this.method = this.getAcceptMethod(body.getClass());
        this.parameterInfos = ParameterInfo.fromTypes(TypeResolver.resolveRawArguments(bodyClass, body.getClass()));
        this.expression = this.createExpression(expression, typeRegistry);
    }

    private StepExpression createExpression(String expression, TypeRegistry typeRegistry) {
        if (this.parameterInfos.isEmpty()) {
            return new StepExpressionFactory(typeRegistry).createExpression(expression);
        }
        ParameterInfo parameterInfo = this.parameterInfos.get(this.parameterInfos.size() - 1);
        return new StepExpressionFactory(typeRegistry).createExpression(expression, (io.cucumber.stepexpression.TypeResolver)new LambdaTypeResolver(parameterInfo));
    }

    private Method getAcceptMethod(Class<? extends StepdefBody> bodyClass) {
        ArrayList<Method> acceptMethods = new ArrayList<Method>();
        for (Method method : bodyClass.getDeclaredMethods()) {
            if (method.isBridge() || method.isSynthetic() || !"accept".equals(method.getName())) continue;
            acceptMethods.add(method);
        }
        if (acceptMethods.size() != 1) {
            throw new IllegalStateException(String.format("Expected single 'accept' method on body class, found '%s'", acceptMethods));
        }
        return (Method)acceptMethods.get(0);
    }

    private CucumberException withLocation(CucumberException exception) {
        exception.setStackTrace(new StackTraceElement[]{this.location});
        return exception;
    }

    public List<Argument> matchedArguments(PickleStep step) {
        ExpressionArgumentMatcher argumentMatcher = new ExpressionArgumentMatcher(this.expression);
        Type[] types = new Type[this.parameterInfos.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.parameterInfos.get(i).getType();
        }
        return argumentMatcher.argumentsFrom(step, types);
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public void execute(Object[] args) throws Throwable {
        Utils.invoke((Object)this.body, (Method)this.method, (long)this.timeoutMillis, (Object[])args);
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName() != null && this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.expression.getSource();
    }

    public boolean isScenarioScoped() {
        return true;
    }

    public void disposeScenarioScope() {
        this.body = null;
    }

    private final class LambdaTypeResolver
    implements io.cucumber.stepexpression.TypeResolver {
        private final ParameterInfo parameterInfo;

        LambdaTypeResolver(ParameterInfo parameterInfo) {
            this.parameterInfo = parameterInfo;
        }

        public Type resolve() {
            Type type = this.parameterInfo.getType();
            if (TypeResolver.Unknown.class.equals((Object)type)) {
                return Object.class;
            }
            return this.requireNonMapOrListType(type);
        }

        private Type requireNonMapOrListType(Type argumentType) {
            Class argumentClass;
            if (argumentType instanceof Class && (List.class.isAssignableFrom(argumentClass = (Class)argumentType) || Map.class.isAssignableFrom(argumentClass))) {
                throw Java8StepDefinition.this.withLocation(new CucumberException(String.format("Can't use %s in lambda step definition \"%s\". Declare a DataTable argument instead and convert manually with asList/asLists/asMap/asMaps", argumentClass.getName(), Java8StepDefinition.this.expression.getSource())));
            }
            return argumentType;
        }
    }
}

