/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.format;

import io.cloudevents.Attributes;
import io.cloudevents.CloudEvent;
import io.cloudevents.format.builder.HeadersStep;
import io.cloudevents.format.builder.PayloadStep;
import io.cloudevents.format.builder.UnmarshalStep;
import io.cloudevents.fun.EnvelopeUnmarshaller;
import io.cloudevents.fun.ExtensionUmarshaller;
import io.cloudevents.fun.FormatExtensionMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class StructuredUnmarshaller {
    StructuredUnmarshaller() {
    }

    public static <A extends Attributes, T, P> ExtensionMapperStep<A, T, P> builder() {
        return new Builder();
    }

    private static final class Builder<A extends Attributes, T, P>
    implements ExtensionMapperStep<A, T, P>,
    ExtensionUnmarshallerStep<A, T, P>,
    EnvelopeUnmarshallerStep<A, T, P>,
    HeadersStep<A, T, P>,
    PayloadStep<A, T, P>,
    UnmarshalStep<A, T> {
        private FormatExtensionMapper extensionMapper;
        private Set<ExtensionUmarshaller> extensionUnmarshallers = new HashSet<ExtensionUmarshaller>();
        private EnvelopeUnmarshaller<A, T, P> unmarshaller;
        private Supplier<Map<String, Object>> headersSupplier;
        private Supplier<P> payloadSupplier;

        private Builder() {
        }

        @Override
        public Builder<A, T, P> next() {
            return this;
        }

        @Override
        public EnvelopeUnmarshallerStep<A, T, P> skip() {
            return this;
        }

        @Override
        public ExtensionUnmarshallerStep<A, T, P> map(FormatExtensionMapper mapper) {
            Objects.requireNonNull(mapper);
            this.extensionMapper = mapper;
            return this;
        }

        @Override
        public ExtensionUnmarshallerStep<A, T, P> map(ExtensionUmarshaller unmarshaller) {
            Objects.requireNonNull(unmarshaller);
            this.extensionUnmarshallers.add(unmarshaller);
            return this;
        }

        @Override
        public HeadersStep<A, T, P> map(EnvelopeUnmarshaller<A, T, P> unmarshaller) {
            Objects.requireNonNull(unmarshaller);
            this.unmarshaller = unmarshaller;
            return this;
        }

        @Override
        public PayloadStep<A, T, P> withHeaders(Supplier<Map<String, Object>> headers) {
            Objects.requireNonNull(headers);
            this.headersSupplier = headers;
            return this;
        }

        @Override
        public UnmarshalStep<A, T> withPayload(Supplier<P> payload) {
            Objects.requireNonNull(payload);
            this.payloadSupplier = payload;
            return this;
        }

        @Override
        public CloudEvent<A, T> unmarshal() {
            Map<String, Object> headers = this.headersSupplier.get();
            P payload = this.payloadSupplier.get();
            Map extensionsMap = Optional.ofNullable(this.extensionMapper).map((? super T mapper) -> mapper.map(headers)).orElse(new HashMap());
            CloudEvent<A, T> result = this.unmarshaller.unmarshal(payload, () -> this.extensionUnmarshallers.stream().map((? super T unmarshaller) -> unmarshaller.unmarshal(extensionsMap)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            return result;
        }
    }

    public static interface EnvelopeUnmarshallerStep<A extends Attributes, T, P> {
        public HeadersStep<A, T, P> map(EnvelopeUnmarshaller<A, T, P> var1);
    }

    public static interface ExtensionUnmarshallerStep<A extends Attributes, T, P> {
        public ExtensionUnmarshallerStep<A, T, P> map(ExtensionUmarshaller var1);

        public EnvelopeUnmarshallerStep<A, T, P> next();
    }

    public static interface ExtensionMapperStep<A extends Attributes, T, P> {
        public EnvelopeUnmarshallerStep<A, T, P> skip();

        public ExtensionUnmarshallerStep<A, T, P> map(FormatExtensionMapper var1);
    }
}

