/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.main;

import io.apisense.generation.dart.html.HTMLVisitor;
import io.apisense.generation.dart.html.JsDocLinker;
import io.apisense.generation.dart.java.JavaVisitor;
import io.apisense.generation.dart.objc.IOSVisitor;
import io.apisense.interpretor.parser.DartParser;
import io.apisense.interpretor.structure.Dart;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DartGenerator {
    private final File outputDir;
    private final String packageDir;

    public DartGenerator(File outputDir) {
        this(outputDir, "io.apisense.dart");
    }

    public DartGenerator(File outputDir, String basePackage) {
        this.outputDir = outputDir;
        this.packageDir = basePackage.replace(".", File.separator);
    }

    public void writeFiles(Map<File, String> files) throws IOException {
        for (File file : files.keySet()) {
            String content = files.get(file);
            file.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(file);
            fw.write(content);
            file.createNewFile();
            fw.close();
        }
    }

    public Map<File, String> generateJava(List<Dart> darts) throws IOException {
        File output = new File(this.outputDir, this.packageDir);
        HashMap<File, String> res = new HashMap<File, String>();
        for (Dart dart : darts) {
            JavaVisitor jv = new JavaVisitor(dart.getName());
            res.putAll(dart.accept(jv, output));
        }
        return res;
    }

    public Map<File, String> generateIOS(List<Dart> darts) throws IOException {
        HashMap<File, String> res = new HashMap<File, String>();
        for (Dart dart : darts) {
            IOSVisitor iosv = new IOSVisitor(dart.getName());
            res.putAll(dart.accept(iosv, this.outputDir));
        }
        return res;
    }

    public Map<File, String> generateHTML(List<Dart> darts) throws IOException {
        return this.generateHTML(darts, JsDocLinker.EMPTY_LINKER);
    }

    public Map<File, String> generateHTML(List<Dart> darts, JsDocLinker linker) throws IOException {
        HashMap<File, String> res = new HashMap<File, String>();
        for (Dart dart : darts) {
            HTMLVisitor htmlv = new HTMLVisitor(dart.getName(), linker);
            res.putAll(dart.accept(htmlv, this.outputDir));
        }
        return res;
    }

    public static void main(String[] args) throws Exception {
        HashMap<File, String> res = new HashMap<File, String>();
        ArrayList<Dart> darts = new ArrayList<Dart>();
        for (String s : args) {
            DartParser dp = new DartParser(new File(s));
            Dart dart = dp.readDart();
            darts.add(dart);
        }
        DartGenerator dartGenerator = new DartGenerator(new File("generated/java"));
        res.putAll(dartGenerator.generateJava(darts));
        dartGenerator = new DartGenerator(new File("generated/html"));
        res.putAll(dartGenerator.generateHTML(darts));
        dartGenerator = new DartGenerator(new File("generated/ios"));
        res.putAll(dartGenerator.generateIOS(darts));
        dartGenerator.writeFiles(res);
    }
}

