/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.objc;

import io.apisense.generation.dart.adapter.velocity.VelocityGenerator;
import io.apisense.generation.dart.objc.ToIOStypes;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.structure.Dart;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;

final class GenerateIOS
extends VelocityGenerator {
    private static final Map<String, String> TEMPLATE_TO_SUFFIX = new HashMap<String, String>();

    GenerateIOS(String dartName) {
        super(dartName);
    }

    void generateIOS(Dart dart) throws IOException {
        VelocityContext context = this.minimalContext();
        context.put("dart", (Object)dart);
        context.put("iosTypes", ToIOStypes.class);
        for (String template : TEMPLATE_TO_SUFFIX.keySet()) {
            Template t = this.loadTemplate(template);
            String fileSuffix = TEMPLATE_TO_SUFFIX.get(template);
            this.generated.put(fileSuffix, this.fillTemplate(t, context));
        }
    }

    @Override
    protected String getTemplatePath(String name) {
        return "/template/iOS/" + name + ".vm";
    }

    @Override
    protected File getOutputFile(File parentDir, String suffix) {
        return new File(parentDir, "APS" + StringUtils.capitalize(this.dartName) + suffix);
    }

    static {
        TEMPLATE_TO_SUFFIX.put("DataH", "Data.h");
        TEMPLATE_TO_SUFFIX.put("DataM", "Data.m");
        TEMPLATE_TO_SUFFIX.put("StingH", "Sting.h");
        TEMPLATE_TO_SUFFIX.put("StingM", "Sting.m");
    }
}

