/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.structure;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.structure.DartVisitor;
import io.apisense.interpretor.structure.Describable;
import io.apisense.interpretor.structure.Filter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Sprout
extends Describable
implements Comparable<Sprout> {
    private static final String EVENT_SEPARATOR = ":";
    private String event;
    private List<Filter> filters;
    @JsonProperty(value="privateFilters")
    private boolean privateFilters;

    public Sprout() {
    }

    public Sprout(String event, String trigger, List<Filter> filters, boolean privateFilters, String description, Map<String, String> properties) {
        super(description, properties);
        this.event = event + EVENT_SEPARATOR + trigger;
        this.filters = filters;
        this.privateFilters = privateFilters;
    }

    public String getEvent() {
        String[] eventTrigger = this.event.split(EVENT_SEPARATOR);
        return eventTrigger.length >= 1 ? eventTrigger[0] : "";
    }

    public String getTrigger() {
        String[] eventTrigger = this.event.split(EVENT_SEPARATOR);
        return eventTrigger.length >= 2 ? eventTrigger[1] : "";
    }

    public List<Filter> getFilters() {
        return this.filters != null ? this.filters : Collections.emptyList();
    }

    public boolean areFiltersPrivate() {
        return this.privateFilters;
    }

    public String eventName() {
        String s = this.getEvent().isEmpty() ? this.getTrigger() : (this.getTrigger().isEmpty() ? this.getEvent() : this.getEvent() + StringUtils.capitalize(this.getTrigger()));
        return s;
    }

    public String eventMethodName() {
        String s = this.getEvent().isEmpty() ? this.getTrigger() : "on" + StringUtils.capitalize(this.eventName());
        return s;
    }

    public String eventConstantName() {
        String name = "";
        if (!this.getEvent().isEmpty()) {
            name = this.getEvent().toUpperCase();
        }
        if (!this.getTrigger().isEmpty()) {
            if (!name.isEmpty()) {
                name = name + "_";
            }
            name = name + this.getTrigger().toUpperCase();
        }
        return name;
    }

    public String eventValue(String dartName) {
        String val = dartName.toLowerCase() + EVENT_SEPARATOR;
        if (!this.getEvent().isEmpty()) {
            val = val + this.getEvent() + EVENT_SEPARATOR;
        }
        if (!this.getTrigger().isEmpty()) {
            val = val + this.getTrigger();
        }
        return val;
    }

    public String eventListenerName() {
        String methodName = "init" + StringUtils.capitalize(this.eventName());
        if (!this.getEvent().isEmpty()) {
            methodName = methodName + "Listener";
        }
        return methodName;
    }

    public String eventFilterName() {
        return StringUtils.capitalize(this.getEvent() + StringUtils.capitalize(this.getTrigger()) + "Filter");
    }

    public void accept(DartVisitor visitor) throws IOException {
        visitor.visitSprout(this);
    }

    @Override
    public int compareTo(Sprout s) {
        return this.event.compareToIgnoreCase(s.event);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sprout sprout = (Sprout)o;
        return this.event.equals(sprout.event);
    }

    public int hashCode() {
        return this.event.hashCode();
    }
}

