/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.java.dart;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.apisense.generation.dart.adapter.javapoet.GlobalGenerator;
import io.apisense.generation.dart.adapter.javapoet.JavaPoetGenerator;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.structure.Dart;
import io.apisense.interpretor.structure.Enumeration;
import io.apisense.interpretor.structure.Filter;
import io.apisense.interpretor.structure.Parameter;
import io.apisense.interpretor.structure.Seed;
import io.apisense.interpretor.structure.Sprout;
import io.apisense.interpretor.structure.Treatment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;

public final class GenerateDartInterface
extends JavaPoetGenerator
implements GlobalGenerator {
    private static final String FILE_SUFFIX = "Dart";
    private static final ClassName DART_INTERFACE = ClassName.get((String)"io.apisense.dart.api", (String)"Dart", (String[])new String[0]);

    public GenerateDartInterface() {
        super(FILE_SUFFIX);
    }

    @Override
    public void setDart(Dart dart) {
        this.setDartName(dart.getName());
        this.contentBuilder = TypeSpec.interfaceBuilder((String)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)DART_INTERFACE, (TypeName[])new TypeName[]{ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + "Data"), (String[])new String[0])}));
        FieldSpec name = FieldSpec.builder(String.class, (String)"NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.dartName()}).addJavadoc("identifier of the sting to be used as require('$N').\n", new Object[]{this.dartName()}).build();
        this.contentBuilder.addField(name).addJavadoc("Retrieve data about the user $N.\n", new Object[]{this.dartName()});
    }

    @Override
    public void addSeed(Seed seed) {
        if (seed.getType() instanceof Enumeration) {
            this.contentBuilder.addFields(this.dataFields(StringUtils.capitalize(seed.getName()), (Enumeration)seed.getType()));
            this.contentBuilder.addMethod(this.dataFunction(seed));
        }
        this.contentBuilder.addMethod(this.getter(seed));
    }

    @Override
    public void addSprout(Sprout sprout) {
        this.contentBuilder.addMethod(this.eventListener(sprout));
    }

    @Override
    public void addTreatment(Treatment treatment) {
        this.contentBuilder.addMethod(this.generateMethod(treatment));
    }

    private MethodSpec generateMethod(Treatment method) {
        MethodSpec.Builder specs = MethodSpec.methodBuilder((String)method.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(method.getType().generableClass()).addJavadoc("$N\n", new Object[]{method.getDescription()});
        for (Parameter param : method.getParameters()) {
            specs.addParameter(ParameterSpec.builder((TypeName)param.getType().generableClass(), (String)param.getName(), (Modifier[])new Modifier[0]).build());
            specs.addJavadoc("\n@param $N $N", new Object[]{param.getName(), param.getDescription()});
        }
        if (!method.getReturned().isEmpty()) {
            specs.addJavadoc("\n@return $N", new Object[]{method.getReturned()});
        }
        specs.addJavadoc("\n", new Object[0]);
        return specs.build();
    }

    private List<FieldSpec> dataFields(String seedName, Enumeration enumeration) {
        ClassName seedClass = ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + seedName), (String[])new String[0]);
        ArrayList<FieldSpec> res = new ArrayList<FieldSpec>();
        for (String seedValue : enumeration.getElements()) {
            res.add(FieldSpec.builder(Integer.TYPE, (String)seedValue, (Modifier[])new Modifier[0]).initializer("$T.$L.value()", new Object[]{seedClass, seedValue}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Constant representing the $N $N of the $N.\n", new Object[]{seedValue, seedName, this.dartName()}).build());
        }
        return res;
    }

    private MethodSpec dataFunction(Seed seed) {
        String s = seed.getName();
        return MethodSpec.methodBuilder((String)("is" + StringUtils.capitalize(seed.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(Boolean.TYPE).addParameter(Integer.TYPE, s, new Modifier[]{Modifier.FINAL}).addJavadoc("Tells if the current $N correspond to the asked $N.\n\n@param $N The $N to check.\n@return true if $Ns matches, false otherwise.\n", new Object[]{s, s, s, s, s}).build();
    }

    private MethodSpec getter(Seed seed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)seed.getName());
        builder.returns(seed.getType().generableClass());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addJavadoc("Return the current $N of the $N.\n\n", new Object[]{seed.getName(), this.dartName()});
        for (Parameter p : seed.getParameters()) {
            builder.addParameter(p.getType().generableClass(), p.getName(), new Modifier[0]);
            builder.addJavadoc("@param $N The form $N\n", new Object[]{p.getName(), p.getName()});
        }
        builder.addJavadoc("@return The $N $N.\n", new Object[]{this.dartName(), seed.getName()});
        return builder.build();
    }

    private MethodSpec eventListener(Sprout sprout) {
        String eventTrigger = sprout.eventMethodName();
        MethodSpec.Builder ms = MethodSpec.methodBuilder((String)eventTrigger).returns((TypeName)TOKEN_CLASS).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        ms.addJavadoc("Execute the callback when the $N dart detects a $N.\n", new Object[]{this.dartName(), sprout.eventName()});
        if (!sprout.areFiltersPrivate() && sprout.getFilters().size() >= 1) {
            String filterLabel;
            TypeName filterType;
            ms.addJavadoc("Provided that the filters matches with the filters.\n", new Object[0]);
            if (sprout.getFilters().size() == 1) {
                Filter f = sprout.getFilters().get(0);
                filterType = f.getType().generableClass();
                filterLabel = f.getLabel();
                ms.addJavadoc("\n@param $N   The $N configuration to set, can contain:", new Object[]{filterLabel, filterLabel});
            } else {
                ClassName filterClass = ClassName.get((String)this.generationPackage(), (String)sprout.eventFilterName(), (String[])new String[0]);
                filterType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{filterClass, ClassName.get(Object.class)});
                filterLabel = "filter";
                ms.addJavadoc("\n@param filter   The $N configuration to set, can contain:", new Object[]{this.dartName()});
                Iterator<Filter> it = sprout.getFilters().iterator();
                while (it.hasNext()) {
                    Filter filter = it.next();
                    char c = it.hasNext() ? (char)',' : '.';
                    ms.addJavadoc("\n                - $N ($N): $N$L", new Object[]{filter.getLabel(), filter.getType().simpleName(), filter.getDescription(), Character.valueOf(c)});
                }
            }
            ms.addParameter(filterType, filterLabel, new Modifier[0]);
        }
        ms.addParameter(Object.class, "callback", new Modifier[0]).addJavadoc("\n@param callback The action to process when done.\n@return The cancellation Token.\n", new Object[0]);
        return ms.build();
    }
}

