/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.java;

import io.apisense.generation.dart.GenericVisitor;
import io.apisense.generation.dart.adapter.javapoet.GlobalGenerator;
import io.apisense.generation.dart.adapter.javapoet.JavaGenerator;
import io.apisense.generation.dart.adapter.javapoet.OneShotGenerator;
import io.apisense.generation.dart.java.dart.GenerateDartInterface;
import io.apisense.generation.dart.java.dart.GenerateDartSkel;
import io.apisense.generation.dart.java.data.GenerateData;
import io.apisense.generation.dart.java.enums.GenerateEnumSeed;
import io.apisense.generation.dart.java.enums.GenerateEnumSprouts;
import io.apisense.generation.dart.java.enums.GenerateEventFilter;
import io.apisense.generation.dart.java.enums.GenerateSeed;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.structure.Dart;
import io.apisense.interpretor.structure.Enumeration;
import io.apisense.interpretor.structure.Seed;
import io.apisense.interpretor.structure.Sprout;
import io.apisense.interpretor.structure.Treatment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaVisitor
extends GenericVisitor {
    private List<GlobalGenerator> commonGenerators = new ArrayList<GlobalGenerator>();
    private List<OneShotGenerator> oneShotGenerators;

    public JavaVisitor(String dartName) {
        super(dartName);
        this.commonGenerators.add(new GenerateDartInterface());
        this.commonGenerators.add(new GenerateDartSkel());
        this.commonGenerators.add(new GenerateData());
        this.commonGenerators.add(new GenerateSeed());
        this.commonGenerators.add(new GenerateEnumSprouts());
        this.oneShotGenerators = new ArrayList<OneShotGenerator>();
    }

    @Override
    public void visitDart(Dart dart, File output) throws IOException {
        for (GlobalGenerator generator : this.commonGenerators) {
            generator.setDart(dart);
        }
    }

    @Override
    public void visitSeed(Seed seed) throws IOException {
        for (GlobalGenerator generator : this.commonGenerators) {
            generator.addSeed(seed);
        }
        if (seed.getType() instanceof Enumeration) {
            GenerateEnumSeed enumSeed = new GenerateEnumSeed(this.dartName, StringUtils.capitalize(seed.getName()));
            enumSeed.generate(seed);
            this.oneShotGenerators.add(enumSeed);
        }
    }

    @Override
    public void visitSprout(Sprout sprout) throws IOException {
        for (GlobalGenerator generator : this.commonGenerators) {
            generator.addSprout(sprout);
        }
        if (sprout.getFilters().size() > 1) {
            GenerateEventFilter eventFilter = new GenerateEventFilter(this.dartName);
            eventFilter.generate(sprout);
            this.oneShotGenerators.add(eventFilter);
        }
    }

    @Override
    public void visitTreatment(Treatment treatment) {
        for (GlobalGenerator generator : this.commonGenerators) {
            generator.addTreatment(treatment);
        }
    }

    public HashMap<File, String> results(File parent) {
        HashMap<File, String> res = new HashMap<File, String>();
        res.putAll(this.generatedContent(parent, this.commonGenerators));
        res.putAll(this.generatedContent(parent, this.oneShotGenerators));
        return res;
    }

    private Map<File, String> generatedContent(File parent, List<? extends JavaGenerator> generators) {
        File output = this.outputDir(parent);
        HashMap<File, String> res = new HashMap<File, String>();
        for (JavaGenerator javaGenerator : generators) {
            String content = javaGenerator.fileContent();
            if (content == null) continue;
            res.put(this.getFile(output, javaGenerator), content);
        }
        return res;
    }

    private File getFile(File parent, JavaGenerator generator) {
        return new File(parent, generator.className() + ".java");
    }
}

