/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.adapter.velocity;

import io.apisense.generation.dart.adapter.velocity.VelocityUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class VelocityGenerator {
    private final VelocityEngine engine;
    protected Map<String, String> generated;
    protected final String dartName;

    public VelocityGenerator(String dartName) {
        this.dartName = dartName;
        this.engine = new VelocityEngine();
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        this.engine.init();
        this.generated = new HashMap<String, String>();
    }

    protected VelocityContext minimalContext() {
        VelocityContext context = new VelocityContext();
        context.put("Utils", VelocityUtils.class);
        return context;
    }

    protected String fillTemplate(Template t, VelocityContext context) {
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    protected Template loadTemplate(String name) throws IOException {
        String location = this.getTemplatePath(name);
        return this.engine.getTemplate(location);
    }

    protected abstract String getTemplatePath(String var1);

    protected abstract File getOutputFile(File var1, String var2);

    public Map<File, String> filesContent(File parentDir) {
        HashMap<File, String> res = new HashMap<File, String>();
        for (String suffix : this.generated.keySet()) {
            res.put(this.getOutputFile(parentDir, suffix), this.generated.get(suffix));
        }
        return res;
    }
}

