/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.structure;

import io.apisense.generation.dart.GeneratedType;
import io.apisense.interpretor.structure.DartVisitor;
import io.apisense.interpretor.structure.Describable;
import io.apisense.interpretor.structure.Parameter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Treatment
extends Describable
implements Comparable<Treatment> {
    private String name;
    private GeneratedType type;
    private List<Parameter> parameters;
    private String returned;

    public Treatment() {
    }

    public Treatment(String name, GeneratedType type, List<Parameter> parameters, String description, Map<String, String> properties) {
        super(description, properties);
        this.name = name;
        this.type = type;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public GeneratedType getType() {
        return this.type;
    }

    public List<Parameter> getParameters() {
        return this.parameters != null ? this.parameters : Collections.emptyList();
    }

    public String getReturned() {
        return this.returned != null ? this.returned : "";
    }

    public void accept(DartVisitor visitor) throws IOException {
        visitor.visitTreatment(this);
    }

    @Override
    public int compareTo(Treatment t) {
        return this.name.compareToIgnoreCase(t.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Treatment treatment = (Treatment)o;
        return this.name.equals(treatment.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

