/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.interpretor.parser;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.apisense.generation.dart.GeneratedType;
import io.apisense.interpretor.parser.TypeDeserializer;
import io.apisense.interpretor.structure.Dart;
import java.io.File;
import java.io.IOException;

public class DartParser {
    private static final String DART_SCHEMA_JSON = "dartSchema.json";
    private static final String DART_NAME = "name";
    private final JsonNode rootNode;

    public DartParser(File file) throws Exception {
        if (file.isDirectory()) {
            throw new IOException("The selected file is a directory");
        }
        if (!file.getName().endsWith(".dart")) {
            throw new IOException("The selected file is not a dart file");
        }
        this.rootNode = this.validateDartJson(file);
    }

    public Dart readDart() throws Exception {
        String dartName = this.rootNode.get(DART_NAME).asText();
        ObjectCodec objectCodec = this.getJacksonCodec(dartName);
        return (Dart)this.rootNode.traverse(objectCodec).readValueAs(Dart.class);
    }

    private JsonNode validateDartJson(File f) throws Exception {
        JsonNode root;
        JsonSchema schema = JsonSchemaFactory.byDefault().getJsonSchema("resource:/dartSchema.json");
        ProcessingReport report = schema.validate(root = JsonLoader.fromFile((File)f));
        if (!report.isSuccess()) {
            String errors = "";
            for (ProcessingMessage processingMessage : report) {
                errors = errors + processingMessage.getMessage() + ";";
            }
            throw new Exception("Validation failed: " + errors);
        }
        return root;
    }

    private ObjectCodec getJacksonCodec(String dartName) {
        ObjectMapper objectCodec = new ObjectMapper();
        SimpleModule dartModule = new SimpleModule();
        dartModule.addDeserializer(GeneratedType.class, (JsonDeserializer)new TypeDeserializer(dartName));
        objectCodec.registerModule((Module)dartModule);
        return objectCodec;
    }
}

