/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.java.data;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.apisense.generation.dart.adapter.javapoet.GlobalGenerator;
import io.apisense.generation.dart.adapter.javapoet.JavaPoetGenerator;
import io.apisense.interpretor.structure.Dart;
import io.apisense.interpretor.structure.Seed;
import io.apisense.interpretor.structure.Sprout;
import io.apisense.interpretor.structure.Treatment;
import javax.lang.model.element.Modifier;

public class GenerateData
extends JavaPoetGenerator
implements GlobalGenerator {
    private static final String CLASS_SUFFIX = "Data";
    private static final ClassName DATA_IMPL_CLASS = ClassName.get((String)"io.apisense.dart.lib", (String)"DataImpl", (String[])new String[0]);
    private MethodSpec.Builder constructorBuilder;

    public GenerateData() {
        super(CLASS_SUFFIX);
    }

    @Override
    public String fileContent() {
        this.contentBuilder.addMethod(this.constructorBuilder.build());
        return super.fileContent();
    }

    @Override
    public void setDart(Dart dart) {
        this.setDartName(dart.getName());
        this.contentBuilder = TypeSpec.classBuilder((String)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)DATA_IMPL_CLASS);
        this.prepareConstructor(dart);
    }

    @Override
    public void addSeed(Seed seed) {
        this.contentBuilder.addField(this.field(seed));
        this.addConstructorParameter(seed);
    }

    @Override
    public void addTreatment(Treatment treatment) {
    }

    @Override
    public void addSprout(Sprout sprout) {
    }

    private void prepareConstructor(Dart dart) {
        this.constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (dart.getSeeds().size() > 0) {
            this.constructorBuilder.addParameter(Integer.TYPE, "seeds", new Modifier[]{Modifier.FINAL}).addStatement("super(seeds)", new Object[0]);
        } else {
            this.constructorBuilder.addStatement("super(0)", new Object[0]);
        }
    }

    private void addConstructorParameter(Seed seed) {
        String seedName = seed.getName();
        this.constructorBuilder.addParameter(seed.getType().generableClass(), seedName, new Modifier[]{Modifier.FINAL});
        this.constructorBuilder.addStatement("this.$N = $N", new Object[]{seedName, seedName});
    }

    private FieldSpec field(Seed seed) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)seed.getType().generableClass(), (String)seed.getName(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        return builder.build();
    }
}

