/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.dart.java.dart;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import io.apisense.generation.dart.adapter.javapoet.GlobalGenerator;
import io.apisense.generation.dart.adapter.javapoet.JavaPoetGenerator;
import io.apisense.interpretor.main.StringUtils;
import io.apisense.interpretor.structure.Dart;
import io.apisense.interpretor.structure.Enumeration;
import io.apisense.interpretor.structure.Filter;
import io.apisense.interpretor.structure.Parameter;
import io.apisense.interpretor.structure.Seed;
import io.apisense.interpretor.structure.Sprout;
import io.apisense.interpretor.structure.Treatment;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class GenerateDartSkel
extends JavaPoetGenerator
implements GlobalGenerator {
    private static final String FILE_SUFFIX = "DartSkel";
    private static final ClassName DART_IMPL = ClassName.get((String)"io.apisense.dart.lib", (String)"DartImpl", (String[])new String[0]);
    private static final ClassName EVENT_BUS_CLASS = ClassName.get((String)"io.apisense.dart.lib", (String)"EventBus", (String[])new String[0]);
    private static final ClassName TOKENS_CLASS = ClassName.get((String)"io.apisense.dart.lib", (String)"Tokens", (String[])new String[0]);
    private static final ClassName SEED_CLASS = ClassName.get((String)"io.apisense.dart.api", (String)"Seed", (String[])new String[0]);
    private static final ClassName TOKENS_LISTENER_CLASS = ClassName.get((String)"io.apisense.dart.lib.Tokens", (String)"TokensListener", (String[])new String[0]);
    private static final String FILTER_DEFAULT_LABEL = "filter";
    private ClassName dataClass;
    private ClassName seedClass;
    private String mapArgs = "";
    private boolean hasFilters = false;
    private MethodSpec.Builder constructorBuilder;
    private MethodSpec.Builder stopBuilder;

    public GenerateDartSkel() {
        super(FILE_SUFFIX);
    }

    @Override
    public void setDart(Dart dart) {
        this.setDartName(dart.getName());
        this.dataClass = ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + "Data"), (String[])new String[0]);
        this.seedClass = ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + "Seed"), (String[])new String[0]);
        ClassName dartClass = ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + "Dart"), (String[])new String[0]);
        this.constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)EVENT_BUS_CLASS, "bus", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)SEED_CLASS)}), "fields", new Modifier[]{Modifier.FINAL}).addStatement("super($T.class, fields)", new Object[]{dartClass}).addStatement("this.$N = $N", new Object[]{"bus", "bus"});
        this.stopBuilder = MethodSpec.methodBuilder((String)"stop").addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.contentBuilder = TypeSpec.classBuilder((String)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).superclass((TypeName)ParameterizedTypeName.get((ClassName)DART_IMPL, (TypeName[])new TypeName[]{this.dataClass})).addSuperinterface((TypeName)dartClass);
        FieldSpec bus = FieldSpec.builder((TypeName)EVENT_BUS_CLASS, (String)"bus", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        this.contentBuilder.addField(bus);
    }

    @Override
    public void addSeed(Seed seed) {
        if (seed.getType() instanceof Enumeration) {
            this.contentBuilder.addMethod(this.isMethod(seed));
        }
        this.contentBuilder.addMethod(this.getter(seed));
        this.addToMap(seed);
    }

    @Override
    public void addTreatment(Treatment treatment) {
    }

    @Override
    public void addSprout(Sprout sprout) {
        this.contentBuilder.addField(this.field(sprout));
        this.contentBuilder.addMethod(this.initMethod(sprout));
        this.contentBuilder.addMethod(this.eventMethod(sprout));
        this.addToConstructor(sprout);
        this.updateHasFilters(sprout);
        this.addToStop(sprout);
    }

    private void updateHasFilters(Sprout sprout) {
        this.hasFilters = this.hasFilters || !sprout.getFilters().isEmpty();
    }

    @Override
    public String fileContent() {
        this.contentBuilder.addMethod(this.mapMethod(this.mapArgs));
        this.contentBuilder.addMethod(this.publishMethod());
        this.contentBuilder.addMethod(this.constructorBuilder.build());
        this.contentBuilder.addMethod(this.stopBuilder.build());
        return super.fileContent();
    }

    private FieldSpec field(Sprout sprout) {
        ClassName c;
        if (sprout.getFilters().size() == 1) {
            Filter f = sprout.getFilters().get(0);
            c = f.getType().generableClass();
        } else {
            c = sprout.getFilters().size() > 1 ? ClassName.get((String)this.generationPackage(), (String)sprout.eventFilterName(), (String[])new String[0]) : ClassName.get(Void.class);
        }
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)TOKENS_CLASS, (TypeName[])new TypeName[]{c}), (String)sprout.eventName(), (Modifier[])new Modifier[]{Modifier.PRIVATE});
        return builder.build();
    }

    private void addToConstructor(Sprout sprout) {
        String format = "this.$N = new $T<>(bus, $N)";
        String eventName = sprout.eventName();
        String methodName = sprout.eventListenerName() + "()";
        this.constructorBuilder.addStatement(format, new Object[]{eventName, TOKENS_CLASS, methodName});
    }

    private MethodSpec publishMethod() {
        MethodSpec.Builder publishBuilder = MethodSpec.methodBuilder((String)"publish").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).addParameter((TypeName)ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + "Event"), (String[])new String[0]), "event", new Modifier[]{Modifier.FINAL}).addParameter((TypeName)ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + "Data"), (String[])new String[0]), "dataClass", new Modifier[]{Modifier.FINAL});
        if (this.hasFilters) {
            publishBuilder.addParameter((TypeName)ClassName.get((String)"io.apisense.dart.lib", (String)"EventFilter", (String[])new String[0]), FILTER_DEFAULT_LABEL, new Modifier[0]);
        }
        String filterArg = this.hasFilters ? FILTER_DEFAULT_LABEL : "null";
        publishBuilder.addStatement("this.bus.publish($T.build(event.toString(), dataClass, $N))", new Object[]{ClassName.get((String)"io.apisense.dart.lib.events", (String)"EventListenerTriggered", (String[])new String[0]), filterArg});
        return publishBuilder.build();
    }

    private void addToStop(Sprout sprout) {
        this.stopBuilder.addStatement("this.$N.stop()", new Object[]{sprout.eventName()});
    }

    private MethodSpec initMethod(Sprout sprout) {
        ParameterizedTypeName c;
        if (sprout.areFiltersPrivate()) {
            c = ParameterizedTypeName.get((ClassName)TOKENS_LISTENER_CLASS, (TypeName[])new TypeName[]{ClassName.get(String.class)});
        } else if (sprout.getFilters().size() == 1) {
            Iterator<Filter> it = sprout.getFilters().iterator();
            Filter f = it.next();
            c = ParameterizedTypeName.get((ClassName)TOKENS_LISTENER_CLASS, (TypeName[])new TypeName[]{f.getType().generableClass()});
        } else if (!sprout.getFilters().isEmpty()) {
            String filterName = sprout.eventFilterName();
            ClassName filter = ClassName.get((String)this.generationPackage(), (String)filterName, (String[])new String[0]);
            c = ParameterizedTypeName.get((ClassName)TOKENS_LISTENER_CLASS, (TypeName[])new TypeName[]{filter});
        } else {
            c = ParameterizedTypeName.get((ClassName)TOKENS_LISTENER_CLASS, (TypeName[])new TypeName[]{ClassName.get(Void.class)});
        }
        String methodName = sprout.eventListenerName();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)methodName);
        b.returns((TypeName)c).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.ABSTRACT});
        return b.build();
    }

    private void addToMap(Seed seed) {
        this.mapArgs = this.mapArgs + ", " + this.seedClass.simpleName() + "." + seed.getName().toUpperCase() + ".matches(mask) ? this." + seed.getName() + "() : null";
    }

    private MethodSpec mapMethod(String args) {
        MethodSpec.Builder mapBuilder = MethodSpec.methodBuilder((String)"map").addAnnotation(Override.class).returns((TypeName)this.dataClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.TYPE, "mask", new Modifier[]{Modifier.FINAL});
        if (!args.isEmpty()) {
            args = "mask" + args;
        }
        mapBuilder.addStatement("return new $T(" + args + ")", new Object[]{this.dataClass});
        return mapBuilder.build();
    }

    private MethodSpec isMethod(Seed seed) {
        String seedName = seed.getName();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("is" + StringUtils.capitalize(seedName))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Integer.TYPE, "mask", new Modifier[]{Modifier.FINAL}).beginControlFlow("if (!available($T.$N.value()))", new Object[]{this.seedClass, seedName.toUpperCase()}).addStatement("return false", new Object[0]).endControlFlow().addStatement("return $T.parse($N()).matches(mask)", new Object[]{ClassName.get((String)this.generationPackage(), (String)(StringUtils.capitalize(this.dartName()) + StringUtils.capitalize(seedName)), (String[])new String[0]), seedName});
        return b.build();
    }

    private MethodSpec getter(Seed seed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)seed.getName());
        builder.returns(seed.getType().generableClass());
        for (Parameter p : seed.getParameters()) {
            builder.addParameter(p.getType().generableClass(), p.getName(), new Modifier[0]);
        }
        builder.addJavadoc(seed.getDescription(), new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return null", new Object[0]).build();
        return builder.build();
    }

    private MethodSpec eventMethod(Sprout sprout) {
        String filters;
        String methName = sprout.eventMethodName();
        MethodSpec.Builder methBuilder = MethodSpec.methodBuilder((String)methName).returns((TypeName)TOKEN_CLASS).addJavadoc(sprout.getDescription(), new Object[0]);
        if (sprout.areFiltersPrivate()) {
            methBuilder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        } else {
            methBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        TypeName filterType = null;
        String filterName = null;
        if (sprout.getFilters().size() == 1) {
            Filter f = sprout.getFilters().get(0);
            filterType = f.getType().generableClass();
            filterName = f.getLabel();
            filters = "EventFilter.singleValue(" + filterName + ")";
        } else if (sprout.getFilters().size() > 1) {
            ClassName filter = ClassName.get((String)this.generationPackage(), (String)sprout.eventFilterName(), (String[])new String[0]);
            filterType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{filter, ClassName.get(Object.class)});
            filterName = FILTER_DEFAULT_LABEL;
            filters = "EventFilter.withValues(filter)";
        } else {
            filters = "null";
        }
        if (filterType != null && filterName != null) {
            methBuilder.addParameter(filterType, filterName, new Modifier[0]);
        }
        methBuilder.addParameter(Object.class, "callback", new Modifier[0]).addStatement("return this.$N.register(callback, $N)", new Object[]{sprout.eventName(), filters});
        return methBuilder.build();
    }
}

