/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.parodos.workflow.execution.dto.WorkFlowRequestDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkFlowDTOUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowDTOUtil.class);

    public static Map<String, String> convertArgumentListToMap(List<WorkFlowRequestDTO.WorkRequestDTO.ArgumentRequestDTO> argumentRequestDTOList) {
        return argumentRequestDTOList.stream().collect(Collectors.toMap(WorkFlowRequestDTO.WorkRequestDTO.ArgumentRequestDTO::getKey, WorkFlowRequestDTO.WorkRequestDTO.ArgumentRequestDTO::getValue));
    }

    public static Map<String, String> convertWorkRequestDTOToMap(WorkFlowRequestDTO.WorkRequestDTO workRequestDTOS) {
        HashMap<String, String> hm = new HashMap<String, String>();
        workRequestDTOS.getArguments().forEach(i -> hm.put(i.getKey(), i.getValue()));
        return hm;
    }

    public static Map<String, Map<String, String>> convertWorkRequestDTOListToMap(List<WorkFlowRequestDTO.WorkRequestDTO> workRequestDTOS) {
        HashMap<String, Map<String, String>> output = new HashMap<String, Map<String, String>>();
        workRequestDTOS.forEach(arg -> {
            HashMap hm = new HashMap();
            Optional.ofNullable(arg.getArguments()).ifPresent(item -> item.forEach(i -> hm.put(i.getKey(), i.getValue())));
            output.put(arg.getWorkName(), hm);
        });
        return output;
    }

    public static String writeObjectValueAsString(Object objectValue) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(new ObjectMapper().writeValueAsString(objectValue));
        }
        catch (JsonProcessingException e) {
            log.error("Error occurred in string conversion: {}", (Object)e.getMessage());
        }
        return sb.toString();
    }

    public static <T> T readStringAsObject(String stringValue, TypeReference<T> typeReference, T defaultValue) {
        try {
            return (T)new ObjectMapper().readValue(stringValue, typeReference);
        }
        catch (JsonProcessingException e) {
            log.error("Error occurred in object conversion: {}", (Object)e.getMessage());
            return defaultValue;
        }
    }
}

