/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.parodos.workflow.annotation.Assessment;
import com.redhat.parodos.workflow.annotation.Checker;
import com.redhat.parodos.workflow.annotation.Escalation;
import com.redhat.parodos.workflow.annotation.Infrastructure;
import com.redhat.parodos.workflow.definition.dto.WorkFlowCheckerDTO;
import com.redhat.parodos.workflow.definition.service.WorkFlowDefinitionServiceImpl;
import com.redhat.parodos.workflow.enums.WorkFlowProcessingType;
import com.redhat.parodos.workflow.enums.WorkFlowType;
import com.redhat.parodos.workflow.registry.WorkFlowRegistry;
import com.redhat.parodos.workflow.registry.WorkFlowRegistryDelegate;
import com.redhat.parodos.workflow.task.WorkFlowTask;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;

@Component
public class BeanWorkFlowRegistryImpl
implements WorkFlowRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BeanWorkFlowRegistryImpl.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private final Map<String, WorkFlow> workFlows;
    private final Map<String, WorkFlowTask> workFlowTasks;
    private final WorkFlowDefinitionServiceImpl workFlowDefinitionService;

    public BeanWorkFlowRegistryImpl(ConfigurableListableBeanFactory beanFactory, Map<String, WorkFlow> workFlows, Map<String, WorkFlowTask> workFlowTasks, WorkFlowDefinitionServiceImpl workFlowDefinitionService) {
        this.beanFactory = beanFactory;
        this.workFlows = workFlows;
        this.workFlowTasks = workFlowTasks;
        this.workFlowDefinitionService = workFlowDefinitionService;
        if (workFlows == null && workFlowTasks == null) {
            log.error("No workflows or workflowTasks were registered. Initializing an empty collection of workflows so the application can start");
            workFlows = new HashMap<String, WorkFlow>();
            workFlowTasks = new HashMap<String, WorkFlowTask>();
        }
        log.info(">> Detected {} WorkFlow and {} workFlowTasks from the Bean Registry", (Object)workFlows.size(), (Object)workFlowTasks.size());
    }

    @PostConstruct
    void postInit() {
        this.workFlowDefinitionService.cleanAllDefinitionMappings();
        this.workFlows.forEach((arg_0, arg_1) -> this.saveWorkFlow(arg_0, arg_1));
        this.saveChecker(this.workFlowTasks);
        log.info("workflow definitions are loaded in database");
    }

    public WorkFlow getWorkFlowByName(String workFlowName) {
        return (WorkFlow)this.workFlows.get(workFlowName);
    }

    private void saveWorkFlow(String workFlowBeanName, WorkFlow workFlowBean) {
        List works = this.getWorks(workFlowBeanName);
        Pair workFlowTypeDetailsPair = this.getWorkFlowTypeDetails(workFlowBeanName, List.of(Assessment.class, Checker.class, Infrastructure.class, Escalation.class));
        WorkFlowType workFlowType = (WorkFlowType)workFlowTypeDetailsPair.getFirst();
        List workParameters = WorkFlowRegistryDelegate.getWorkParameters((AnnotationAttributes[])((AnnotationAttributes[])((Map)workFlowTypeDetailsPair.getSecond()).get("parameters")));
        this.workFlowDefinitionService.save(workFlowBeanName, workFlowType, workFlowBean.getProperties(), workParameters, works, this.getWorkFlowProcessingType((Object)workFlowBean));
    }

    private List<Work> getWorks(String workFlowName) {
        return Arrays.stream(this.beanFactory.getDependenciesForBean(workFlowName)).filter(dependency -> this.isBeanInstanceOf(this.beanFactory, dependency, new Class[]{WorkFlow.class, WorkFlowTask.class})).map(dependency -> (Work)this.beanFactory.getBean(dependency, Work.class)).toList();
    }

    private void saveChecker(Map<String, WorkFlowTask> workFlowTasks) {
        workFlowTasks.forEach((name, value) -> Arrays.stream(this.beanFactory.getDependenciesForBean(name)).filter(dependency -> this.isBeanInstanceOf(this.beanFactory, dependency, new Class[]{WorkFlow.class})).findFirst().ifPresent(dependency -> {
            try {
                WorkFlowCheckerDTO workFlowCheckerDTO = (WorkFlowCheckerDTO)new ObjectMapper().convertValue(this.getWorkFlowTypeDetails(dependency, List.of(Checker.class)).getSecond(), WorkFlowCheckerDTO.class);
                this.workFlowDefinitionService.saveWorkFlowChecker(name, dependency, workFlowCheckerDTO);
            }
            catch (RuntimeException ignored) {
                log.info("{} is not a checker for {}", dependency, name);
            }
        }));
    }

    private Pair<WorkFlowType, Map<String, Object>> getWorkFlowTypeDetails(String workFlowBeanName, List<Class<? extends Annotation>> workFlowTypeAnnotations) {
        BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(workFlowBeanName);
        if (beanDefinition.getSource() instanceof AnnotatedTypeMetadata) {
            AnnotatedTypeMetadata metadata = (AnnotatedTypeMetadata)beanDefinition.getSource();
            return workFlowTypeAnnotations.stream().filter(clazz -> metadata.getAnnotationAttributes(clazz.getName()) != null).findFirst().map(clazz -> Pair.of((Object)WorkFlowType.valueOf((String)clazz.getSimpleName().toUpperCase()), (Object)metadata.getAnnotationAttributes(clazz.getName()))).orElseThrow(() -> new RuntimeException("workflow missing type! beanName: " + workFlowBeanName));
        }
        throw new RuntimeException("workflow with no annotated type metadata!");
    }

    private WorkFlowProcessingType getWorkFlowProcessingType(Object workFlowBean) {
        String className = workFlowBean.getClass().getTypeName();
        if (className.toUpperCase().contains(WorkFlowProcessingType.PARALLEL.name())) {
            return WorkFlowProcessingType.PARALLEL;
        }
        if (className.toUpperCase().contains(WorkFlowProcessingType.SEQUENTIAL.name())) {
            return WorkFlowProcessingType.SEQUENTIAL;
        }
        return WorkFlowProcessingType.OTHER;
    }

    private boolean isBeanInstanceOf(ConfigurableListableBeanFactory configurableListableBeanFactory, String beanName, Class<?> ... classes) {
        return Arrays.stream(classes).anyMatch(clazz -> {
            try {
                configurableListableBeanFactory.getBean(beanName, clazz);
                return true;
            }
            catch (BeansException e1) {
                return false;
            }
        });
    }

    @PreDestroy
    public void gracefulShutdown() {
        log.info(">> Shutting down the bean workflow registry");
    }
}

