/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.scheduler;

import com.redhat.parodos.workflow.execution.scheduler.WorkFlowSchedulerService;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowSchedulerServiceImpl
implements WorkFlowSchedulerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowSchedulerServiceImpl.class);
    private final TaskScheduler taskScheduler;
    private final Map<UUID, Map<String, ScheduledFuture<?>>> hm = new ConcurrentHashMap();

    public WorkFlowSchedulerServiceImpl(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void schedule(UUID projectId, WorkFlow workFlow, WorkContext workContext, String cronExpression) {
        this.hm.computeIfAbsent(projectId, key -> new HashMap());
        if (!((Map)this.hm.get(projectId)).containsKey(workFlow.getName())) {
            log.info("Scheduling workflow: {} for project: {} to be executed following cron expression: {}", new Object[]{workFlow.getName(), projectId, cronExpression});
            ScheduledFuture scheduledTask = this.taskScheduler.schedule(() -> workFlow.execute(workContext), (Trigger)new CronTrigger(cronExpression, TimeZone.getTimeZone(TimeZone.getDefault().getID())));
            ((Map)this.hm.get(projectId)).put(workFlow.getName(), scheduledTask);
        } else {
            log.info("Workflow: {} is already scheduled for project: {}!", (Object)workFlow.getName(), (Object)projectId);
        }
    }

    public boolean stop(UUID projectId, WorkFlow workFlow) {
        if (this.hm.containsKey(projectId) && ((Map)this.hm.get(projectId)).containsKey(workFlow.getName())) {
            log.info("Stopping workflow: {} for project: {}", (Object)workFlow.getName(), (Object)projectId);
            boolean stopped = ((ScheduledFuture)((Map)this.hm.get(projectId)).get(workFlow.getName())).cancel(false);
            if (stopped) {
                ((Map)this.hm.get(projectId)).remove(workFlow.getName());
                if (((Map)this.hm.get(projectId)).isEmpty()) {
                    this.hm.remove(projectId);
                }
            }
            return stopped;
        }
        log.info("Workflow: {} has not been scheduled for project: {}!", (Object)workFlow.getName(), (Object)projectId);
        return false;
    }
}

