/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.repository;

import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import java.util.List;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface WorkFlowRepository
extends JpaRepository<WorkFlowExecution, UUID> {
    public WorkFlowExecution findFirstByWorkFlowDefinitionIdAndMainWorkFlowExecution(UUID var1, WorkFlowExecution var2);

    public List<WorkFlowExecution> findByMainWorkFlowExecution(WorkFlowExecution var1);

    public List<WorkFlowExecution> findAllByProjectId(UUID var1);

    public WorkFlowExecution findFirstByMainWorkFlowExecutionAndWorkFlowDefinitionId(WorkFlowExecution var1, UUID var2);

    @Query(value="SELECT w FROM workflow_execution w WHERE w.status IN :statuses AND w.mainWorkFlowExecution IS NULL")
    public List<WorkFlowExecution> findByStatusInAndIsMain(@Param(value="statuses") List<WorkFlowStatus> var1);

    @Query(value="SELECT w FROM workflow_execution w WHERE w.status = com.redhat.parodos.workflow.enums.WorkFlowStatus.FAILED and w.mainWorkFlowExecution.id = :mainWorkflowId and EXISTS (SELECT f.type FROM workflow_definition f WHERE f.id = w.workFlowDefinitionId AND f.type = com.redhat.parodos.workflow.enums.WorkFlowType.CHECKER)")
    public List<WorkFlowExecution> findRunningCheckersById(@Param(value="mainWorkflowId") UUID var1);

    @Query(value="SELECT w FROM workflow_execution w WHERE w.mainWorkFlowExecution.id = :mainWorkflowId and EXISTS (SELECT f.type FROM workflow_definition f WHERE f.id = w.workFlowDefinitionId AND f.type = com.redhat.parodos.workflow.enums.WorkFlowType.CHECKER)")
    public List<WorkFlowExecution> findCheckers(@Param(value="mainWorkflowId") UUID var1);

    public WorkFlowExecution findFirstByProjectIdAndMainWorkFlowExecutionIsNullOrderByStartDateDesc(UUID var1);
}

