/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.entity;

import com.redhat.parodos.common.AbstractEntity;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecutionContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import lombok.Generated;

@Entity(name="workflow_execution")
public class WorkFlowExecution
extends AbstractEntity {
    private WorkFlowStatus status;
    @Column(updatable=false)
    private Date startDate;
    private Date endDate;
    @Column(name="workflow_definition_id")
    private UUID workFlowDefinitionId;
    @Column(name="project_id")
    private UUID projectId;
    private String arguments;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="main_workflow_execution_id")
    private WorkFlowExecution mainWorkFlowExecution;
    @OneToMany(mappedBy="mainWorkFlowExecution", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<WorkFlowExecution> subWorkFlowExecution = new ArrayList();
    @OneToOne(mappedBy="mainWorkFlowExecution", cascade={CascadeType.ALL}, orphanRemoval=true)
    private WorkFlowExecutionContext workFlowExecutionContext;

    @Generated
    public static WorkFlowExecutionBuilder builder() {
        return new WorkFlowExecutionBuilder();
    }

    @Generated
    public WorkFlowExecution() {
    }

    @Generated
    public WorkFlowExecution(WorkFlowStatus status, Date startDate, Date endDate, UUID workFlowDefinitionId, UUID projectId, String arguments, WorkFlowExecution mainWorkFlowExecution, List<WorkFlowExecution> subWorkFlowExecution, WorkFlowExecutionContext workFlowExecutionContext) {
        this.status = status;
        this.startDate = startDate;
        this.endDate = endDate;
        this.workFlowDefinitionId = workFlowDefinitionId;
        this.projectId = projectId;
        this.arguments = arguments;
        this.mainWorkFlowExecution = mainWorkFlowExecution;
        this.subWorkFlowExecution = subWorkFlowExecution;
        this.workFlowExecutionContext = workFlowExecutionContext;
    }

    @Generated
    public WorkFlowStatus getStatus() {
        return this.status;
    }

    @Generated
    public Date getStartDate() {
        return this.startDate;
    }

    @Generated
    public Date getEndDate() {
        return this.endDate;
    }

    @Generated
    public UUID getWorkFlowDefinitionId() {
        return this.workFlowDefinitionId;
    }

    @Generated
    public UUID getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getArguments() {
        return this.arguments;
    }

    @Generated
    public WorkFlowExecution getMainWorkFlowExecution() {
        return this.mainWorkFlowExecution;
    }

    @Generated
    public List<WorkFlowExecution> getSubWorkFlowExecution() {
        return this.subWorkFlowExecution;
    }

    @Generated
    public WorkFlowExecutionContext getWorkFlowExecutionContext() {
        return this.workFlowExecutionContext;
    }

    @Generated
    public void setStatus(WorkFlowStatus status) {
        this.status = status;
    }

    @Generated
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setWorkFlowDefinitionId(UUID workFlowDefinitionId) {
        this.workFlowDefinitionId = workFlowDefinitionId;
    }

    @Generated
    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    @Generated
    public void setMainWorkFlowExecution(WorkFlowExecution mainWorkFlowExecution) {
        this.mainWorkFlowExecution = mainWorkFlowExecution;
    }

    @Generated
    public void setSubWorkFlowExecution(List<WorkFlowExecution> subWorkFlowExecution) {
        this.subWorkFlowExecution = subWorkFlowExecution;
    }

    @Generated
    public void setWorkFlowExecutionContext(WorkFlowExecutionContext workFlowExecutionContext) {
        this.workFlowExecutionContext = workFlowExecutionContext;
    }
}

