/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.controller;

import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.execution.dto.WorkFlowCheckerTaskRequestDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowContextResponseDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowRequestDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowResponseDTO;
import com.redhat.parodos.workflow.execution.dto.WorkFlowStatusResponseDTO;
import com.redhat.parodos.workflow.execution.service.WorkFlowService;
import com.redhat.parodos.workflow.execution.validation.PubliclyVisible;
import com.redhat.parodos.workflow.option.WorkFlowOptions;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"}, maxAge=1800L)
@RestController
@Validated
@RequestMapping(value={"/api/v1/workflows"})
@Tag(name="Workflow", description="Operations about workflow")
public class WorkFlowController {
    private final WorkFlowService workFlowService;

    public WorkFlowController(WorkFlowService workFlowService) {
        this.workFlowService = workFlowService;
    }

    @Operation(summary="Executes a workflow")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkFlowResponseDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping
    public ResponseEntity<WorkFlowResponseDTO> execute(@RequestBody @Valid WorkFlowRequestDTO workFlowRequestDTO) {
        WorkReport workReport = this.workFlowService.execute(workFlowRequestDTO);
        if (workReport == null) {
            return ResponseEntity.status((int)500).build();
        }
        String workflowExecutionId = WorkContextDelegate.read((WorkContext)workReport.getWorkContext(), (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ID).toString();
        return ResponseEntity.ok((Object)WorkFlowResponseDTO.builder().workFlowExecutionId(UUID.fromString(workflowExecutionId)).workFlowOptions((WorkFlowOptions)WorkContextDelegate.read((WorkContext)workReport.getWorkContext(), (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.WORKFLOW_OPTIONS)).workStatus(workReport.getStatus()).build());
    }

    @Operation(summary="Updates a workflow checker task status")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded", content={@Content(mediaType="application/json", schema=@Schema(implementation=void.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not found", content={@Content})})
    @PostMapping(value={"/{workFlowExecutionId}/checkers/{workFlowCheckerTaskName}"})
    public void updateWorkFlowCheckerTaskStatus(@PathVariable UUID workFlowExecutionId, @PathVariable String workFlowCheckerTaskName, @Valid @RequestBody WorkFlowCheckerTaskRequestDTO workFlowCheckerTaskRequestDTO) {
        this.workFlowService.updateWorkFlowCheckerTaskStatus(workFlowExecutionId, workFlowCheckerTaskName, workFlowCheckerTaskRequestDTO.getStatus());
    }

    @Operation(summary="Returns a workflow status")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkFlowStatusResponseDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @GetMapping(value={"/{workFlowExecutionId}/status"})
    public ResponseEntity<WorkFlowStatusResponseDTO> getStatus(@PathVariable UUID workFlowExecutionId) {
        return ResponseEntity.ok((Object)this.workFlowService.getWorkFlowStatus(workFlowExecutionId));
    }

    @Operation(summary="Returns workflows by project id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded", content={@Content(mediaType="application/json", schema=@Schema(allOf={WorkFlowStatusResponseDTO.class}))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @GetMapping
    public ResponseEntity<List<WorkFlowResponseDTO>> getStatusByProjectId(@RequestParam(value="projectId", required=false) UUID projectId) {
        return ResponseEntity.ok((Object)(projectId != null ? this.workFlowService.getWorkFlowsByProjectId(projectId) : this.workFlowService.getWorkFlows()));
    }

    @Operation(summary="Returns workflow context parameters")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkFlowContextResponseDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @GetMapping(value={"/{workFlowExecutionId}/context"})
    public ResponseEntity<WorkFlowContextResponseDTO> getWorkflowParameters(@PathVariable UUID workFlowExecutionId, @NotEmpty @RequestParam List<// Could not load outer class - annotation placement on inner may be incorrect
    @PubliclyVisible WorkContextDelegate.Resource> param) {
        WorkFlowContextResponseDTO responseDTO = this.workFlowService.getWorkflowParameters(workFlowExecutionId, param);
        return ResponseEntity.ok((Object)responseDTO);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<String> handle(ConstraintViolationException constraintViolationException) {
        Set violations = constraintViolationException.getConstraintViolations();
        String errorMessage = "ConstraintViolationException occurred.";
        if (!violations.isEmpty()) {
            errorMessage = violations.stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(", "));
        }
        return ResponseEntity.badRequest().body((Object)errorMessage);
    }
}

