/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.continuation;

import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.definition.repository.WorkFlowDefinitionRepository;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.execution.continuation.AsyncWorkFlowContinuerImpl;
import com.redhat.parodos.workflow.execution.continuation.WorkFlowContinuationService;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import com.redhat.parodos.workflows.work.WorkContext;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowContinuationServiceImpl
implements WorkFlowContinuationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowContinuationServiceImpl.class);
    private final WorkFlowDefinitionRepository workFlowDefinitionRepository;
    private final WorkFlowRepository workFlowRepository;
    private final AsyncWorkFlowContinuerImpl asyncWorkFlowContinuerImpl;

    public WorkFlowContinuationServiceImpl(WorkFlowDefinitionRepository workFlowDefinitionRepository, WorkFlowRepository workFlowRepository, AsyncWorkFlowContinuerImpl asyncWorkFlowContinuerImpl) {
        this.workFlowDefinitionRepository = workFlowDefinitionRepository;
        this.workFlowRepository = workFlowRepository;
        this.asyncWorkFlowContinuerImpl = asyncWorkFlowContinuerImpl;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void workFlowRunAfterStartup() {
        log.info("Looking up all IN PROGRESS workflows for ");
        List workFlowExecutions = this.workFlowRepository.findByStatusInAndIsMain(List.of(WorkFlowStatus.IN_PROGRESS, WorkFlowStatus.PENDING));
        log.info("Number of IN PROGRESS or PENDING main workflows is : {}", (Object)workFlowExecutions.size());
        workFlowExecutions.forEach(workFlowExecution -> {
            WorkFlowDefinition workFlowDefinition = (WorkFlowDefinition)this.workFlowDefinitionRepository.findById((Object)workFlowExecution.getWorkFlowDefinitionId()).get();
            this.continueWorkFlow(workFlowExecution.getProjectId(), workFlowDefinition.getName(), workFlowExecution.getWorkFlowExecutionContext().getWorkContext(), workFlowExecution.getId());
        });
    }

    public void continueWorkFlow(UUID projectId, String workflowName, WorkContext workContext, UUID executionId) {
        this.asyncWorkFlowContinuerImpl.executeAsync(projectId, workflowName, workContext, executionId);
    }
}

