/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.aspect;

import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.definition.entity.WorkFlowCheckerMappingDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowTaskDefinition;
import com.redhat.parodos.workflow.definition.repository.WorkFlowTaskDefinitionRepository;
import com.redhat.parodos.workflow.exceptions.WorkflowExecutionNotFoundException;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.entity.WorkFlowTaskExecution;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import com.redhat.parodos.workflow.execution.scheduler.WorkFlowSchedulerServiceImpl;
import com.redhat.parodos.workflow.execution.service.WorkFlowServiceImpl;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflow.task.WorkFlowTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskStatus;
import com.redhat.parodos.workflow.util.WorkFlowDTOUtil;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WorkFlowTaskExecutionAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowTaskExecutionAspect.class);
    private final WorkFlowRepository workFlowRepository;
    private final WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository;
    private final WorkFlowServiceImpl workFlowService;
    private final WorkFlowSchedulerServiceImpl workFlowSchedulerService;

    public WorkFlowTaskExecutionAspect(WorkFlowRepository workFlowRepository, WorkFlowTaskDefinitionRepository workFlowTaskDefinitionRepository, WorkFlowServiceImpl workFlowService, WorkFlowSchedulerServiceImpl workFlowSchedulerService) {
        this.workFlowRepository = workFlowRepository;
        this.workFlowTaskDefinitionRepository = workFlowTaskDefinitionRepository;
        this.workFlowService = workFlowService;
        this.workFlowSchedulerService = workFlowSchedulerService;
    }

    @Pointcut(value="execution(* com.redhat.parodos.workflow.task.WorkFlowTask+.execute(..))")
    public void pointcutScopeTask() {
    }

    @Around(value="pointcutScopeTask() && args(workContext)")
    public WorkReport executeAroundAdviceTask(ProceedingJoinPoint proceedingJoinPoint, WorkContext workContext) {
        WorkReport report;
        String workFlowTaskName = ((WorkFlowTask)proceedingJoinPoint.getTarget()).getName();
        log.info("Before invoking execute() on workflow task name: {}", (Object)workFlowTaskName);
        WorkFlowTaskDefinition workFlowTaskDefinition = this.workFlowTaskDefinitionRepository.findFirstByName(workFlowTaskName);
        UUID mainWorkFlowExecutionId = UUID.fromString(WorkContextDelegate.read((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ID).toString());
        WorkFlowExecution mainWorkFlowExecution = (WorkFlowExecution)this.workFlowRepository.findById((Object)mainWorkFlowExecutionId).orElseThrow(() -> new WorkflowExecutionNotFoundException("mainWorkFlow not found for task: " + workFlowTaskName));
        WorkFlowExecution workFlowExecution = this.handleParentWorkflowUseCase(workContext, workFlowTaskDefinition, mainWorkFlowExecution);
        WorkFlowTaskExecution workFlowTaskExecution = this.workFlowService.getWorkFlowTask(workFlowExecution.getId(), workFlowTaskDefinition.getId());
        if (workFlowTaskExecution == null) {
            workFlowTaskExecution = this.workFlowService.saveWorkFlowTask(WorkFlowDTOUtil.writeObjectValueAsString((Object)WorkContextDelegate.read((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_TASK_EXECUTION, (String)workFlowTaskName, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ARGUMENTS)), workFlowTaskDefinition.getId(), workFlowExecution.getId(), WorkFlowTaskStatus.IN_PROGRESS);
        } else if (!WorkFlowTaskStatus.FAILED.equals((Object)workFlowTaskExecution.getStatus())) {
            log.info("skipping task: {} with status {}", (Object)workFlowTaskName, (Object)workFlowTaskExecution.getStatus().name());
            return new DefaultWorkReport(WorkStatus.valueOf((String)workFlowTaskExecution.getStatus().name()), workContext);
        }
        try {
            report = (WorkReport)proceedingJoinPoint.proceed();
            if (report == null || report.getStatus() == null) {
                throw new NullPointerException("task execution not returns status: " + workFlowTaskName);
            }
        }
        catch (Throwable e) {
            log.error("Workflow task execution {} has failed! error message: {}", (Object)workFlowTaskName, (Object)e.getMessage());
            report = new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_TASK_EXECUTION, (String)workFlowTaskName, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.STATUS, (Object)report.getStatus().name());
        workFlowTaskExecution.setStatus(WorkFlowTaskStatus.valueOf((String)report.getStatus().name()));
        workFlowTaskExecution.setLastUpdateDate(new Date());
        this.workFlowService.updateWorkFlowTask(workFlowTaskExecution);
        if (WorkStatus.COMPLETED.equals((Object)report.getStatus()) && workFlowTaskDefinition.getWorkFlowCheckerMappingDefinition() != null) {
            this.handleChecker(proceedingJoinPoint, workContext, workFlowTaskDefinition, mainWorkFlowExecution);
            return new DefaultWorkReport(WorkStatus.PENDING, workContext);
        }
        return report;
    }

    private void handleChecker(ProceedingJoinPoint proceedingJoinPoint, WorkContext workContext, WorkFlowTaskDefinition workFlowTaskDefinition, WorkFlowExecution mainWorkFlowExecution) {
        WorkFlowExecution checkerWorkFlowExecution = this.workFlowRepository.findFirstByWorkFlowDefinitionIdAndMainWorkFlowExecution(workFlowTaskDefinition.getWorkFlowCheckerMappingDefinition().getId(), mainWorkFlowExecution);
        if (checkerWorkFlowExecution == null) {
            List checkerWorkFlows = ((BaseWorkFlowTask)proceedingJoinPoint.getTarget()).getWorkFlowCheckers();
            this.startCheckerOnSchedule(mainWorkFlowExecution.getProjectId(), workFlowTaskDefinition.getWorkFlowCheckerMappingDefinition().getCheckWorkFlow().getName(), checkerWorkFlows, workFlowTaskDefinition.getWorkFlowCheckerMappingDefinition(), workContext);
        }
    }

    private WorkFlowExecution handleParentWorkflowUseCase(WorkContext workContext, WorkFlowTaskDefinition workFlowTaskDefinition, WorkFlowExecution mainWorkFlowExecution) {
        return workFlowTaskDefinition.getWorkFlowDefinition().getName().equalsIgnoreCase(WorkContextDelegate.read((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_DEFINITION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.NAME).toString()) ? mainWorkFlowExecution : this.workFlowRepository.findFirstByWorkFlowDefinitionIdAndMainWorkFlowExecution(workFlowTaskDefinition.getWorkFlowDefinition().getId(), mainWorkFlowExecution);
    }

    private void startCheckerOnSchedule(UUID projectId, String workFlowName, List<WorkFlow> workFlows, WorkFlowCheckerMappingDefinition workFlowCheckerMappingDefinition, WorkContext workContext) {
        log.info("Schedule workflow checker: {} to run per cron expression: {}", (Object)workFlowName, (Object)workFlowCheckerMappingDefinition.getCronExpression());
        for (WorkFlow workFlow : workFlows) {
            this.workFlowSchedulerService.schedule(projectId, workFlow, workContext, workFlowCheckerMappingDefinition.getCronExpression());
        }
    }
}

