/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.aspect;

import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.execution.aspect.AssessmentInfrastructureWorkFlowPostInterceptor;
import com.redhat.parodos.workflow.execution.aspect.CheckerWorkFlowPostInterceptor;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowExecutionInterceptor;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowInterceptor;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowPostInterceptor;
import com.redhat.parodos.workflow.execution.continuation.WorkFlowContinuationServiceImpl;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import com.redhat.parodos.workflow.execution.scheduler.WorkFlowSchedulerServiceImpl;
import com.redhat.parodos.workflow.execution.service.WorkFlowServiceImpl;
import com.redhat.parodos.workflow.util.WorkFlowDTOUtil;
import com.redhat.parodos.workflow.utils.WorkContextUtils;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Date;
import java.util.UUID;

public abstract class WorkFlowExecutionInterceptor
implements WorkFlowInterceptor {
    protected final WorkFlowServiceImpl workFlowService;
    protected final WorkFlowRepository workFlowRepository;
    protected final WorkContext workContext;
    protected final WorkFlowDefinition workFlowDefinition;
    protected WorkFlowExecution workFlowExecution;
    private final WorkFlowSchedulerServiceImpl workFlowSchedulerService;
    private final WorkFlowContinuationServiceImpl workFlowContinuationServiceImpl;

    public WorkFlowExecutionInterceptor(WorkFlowDefinition workFlowDefinition, WorkContext workContext, WorkFlowServiceImpl workFlowService, WorkFlowRepository workFlowRepository, WorkFlowSchedulerServiceImpl workFlowSchedulerService, WorkFlowContinuationServiceImpl workFlowContinuationServiceImpl) {
        this.workFlowDefinition = workFlowDefinition;
        this.workContext = workContext;
        this.workFlowService = workFlowService;
        this.workFlowRepository = workFlowRepository;
        this.workFlowSchedulerService = workFlowSchedulerService;
        this.workFlowContinuationServiceImpl = workFlowContinuationServiceImpl;
    }

    protected WorkFlowExecution saveWorkFlow(WorkFlowExecution mainWorkFlowExecution) {
        String arguments = WorkFlowDTOUtil.writeObjectValueAsString((Object)WorkContextDelegate.read((WorkContext)this.workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (String)this.workFlowDefinition.getName(), (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ARGUMENTS));
        UUID projectId = WorkContextUtils.getProjectId((WorkContext)this.workContext);
        return this.workFlowService.saveWorkFlow(projectId, this.workFlowDefinition.getId(), WorkFlowStatus.IN_PROGRESS, mainWorkFlowExecution, arguments);
    }

    protected abstract WorkFlowExecution doPreWorkFlowExecution();

    public WorkFlowExecution handlePreWorkFlowExecution() {
        this.workFlowExecution = this.doPreWorkFlowExecution();
        return this.workFlowExecution;
    }

    protected WorkFlowExecution getMainWorkFlowExecution() {
        return null;
    }

    public WorkReport handlePostWorkFlowExecution(WorkReport report, WorkFlow workFlow) {
        this.workFlowExecution.setStatus(WorkFlowStatus.valueOf((String)report.getStatus().name()));
        this.workFlowExecution.setEndDate(new Date());
        WorkFlowPostInterceptor postExecutor = this.createPostExecutor(workFlow, report.getStatus());
        WorkReport workReport = null;
        if (postExecutor != null) {
            workReport = postExecutor.handlePostWorkFlowExecution();
        }
        return workReport == null ? report : workReport;
    }

    private WorkFlowPostInterceptor createPostExecutor(WorkFlow workFlow, WorkStatus workStatus) {
        switch (1.$SwitchMap$com$redhat$parodos$workflow$enums$WorkFlowType[this.workFlowDefinition.getType().ordinal()]) {
            case 1: 
            case 2: {
                return new AssessmentInfrastructureWorkFlowPostInterceptor(this.workFlowDefinition, this.workContext, this.workFlowService, this.workFlowRepository, this.workFlowExecution, this.getMainWorkFlowExecution());
            }
            case 3: {
                return new CheckerWorkFlowPostInterceptor(this.workFlowDefinition, this.workContext, this.workFlowService, this.workFlowSchedulerService, this.workFlowContinuationServiceImpl, this.workFlowExecution, this.getMainWorkFlowExecution(), workFlow, workStatus);
            }
        }
        this.workFlowService.updateWorkFlow(this.workFlowExecution);
        return null;
    }
}

