/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.aspect;

import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.execution.aspect.ContinuedWorkFlowExecutionInterceptor;
import com.redhat.parodos.workflow.execution.aspect.InitialMainWorkflowInterceptor;
import com.redhat.parodos.workflow.execution.aspect.MainWorkFlowExecutionInterceptor;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowExecutionInterceptor;
import com.redhat.parodos.workflow.execution.continuation.WorkFlowContinuationServiceImpl;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import com.redhat.parodos.workflow.execution.scheduler.WorkFlowSchedulerServiceImpl;
import com.redhat.parodos.workflow.execution.service.WorkFlowServiceImpl;
import com.redhat.parodos.workflows.work.WorkContext;
import java.util.Optional;
import java.util.UUID;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WorkFlowExecutionFactory {
    private final WorkFlowServiceImpl workFlowService;
    private final WorkFlowRepository workFlowRepository;
    private final WorkFlowSchedulerServiceImpl workFlowSchedulerService;
    private final WorkFlowContinuationServiceImpl workFlowContinuationServiceImpl;

    public WorkFlowExecutionFactory(WorkFlowServiceImpl workFlowService, WorkFlowRepository workFlowRepository, WorkFlowSchedulerServiceImpl workFlowSchedulerService, WorkFlowContinuationServiceImpl workFlowContinuationServiceImpl) {
        this.workFlowService = workFlowService;
        this.workFlowRepository = workFlowRepository;
        this.workFlowSchedulerService = workFlowSchedulerService;
        this.workFlowContinuationServiceImpl = workFlowContinuationServiceImpl;
    }

    public WorkFlowExecutionInterceptor createExecutionHandler(WorkFlowDefinition definition, WorkContext workContext) {
        UUID mainWorkFlowExecutionId = WorkFlowExecutionFactory.getMainWorkFlowExecutionId((WorkContext)workContext);
        if (mainWorkFlowExecutionId == null) {
            return new InitialMainWorkflowInterceptor(definition, workContext, this.workFlowService, this.workFlowRepository, this.workFlowSchedulerService, this.workFlowContinuationServiceImpl);
        }
        if (WorkFlowExecutionFactory.isMainWorkFlow((WorkFlowDefinition)definition, (WorkContext)workContext)) {
            return new MainWorkFlowExecutionInterceptor(definition, workContext, this.workFlowService, this.workFlowRepository, this.workFlowSchedulerService, this.workFlowContinuationServiceImpl);
        }
        return new ContinuedWorkFlowExecutionInterceptor(definition, workContext, this.workFlowService, this.workFlowRepository, this.workFlowSchedulerService, this.workFlowContinuationServiceImpl);
    }

    static boolean isMainWorkFlow(WorkFlowDefinition workflow, WorkContext workContext) {
        String mainWorkflowName = WorkContextDelegate.read((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_DEFINITION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.NAME).toString();
        return workflow.getName().equals(mainWorkflowName);
    }

    static UUID getMainWorkFlowExecutionId(WorkContext workContext) {
        return Optional.ofNullable(WorkContextDelegate.read((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ID)).map(id -> UUID.fromString(id.toString())).orElse(null);
    }
}

