/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.aspect;

import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.definition.repository.WorkFlowDefinitionRepository;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.enums.WorkFlowType;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowExecutionFactory;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowExecutionInterceptor;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.scheduler.WorkFlowSchedulerServiceImpl;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WorkFlowExecutionAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkFlowExecutionAspect.class);
    private final WorkFlowSchedulerServiceImpl workFlowSchedulerService;
    private final WorkFlowDefinitionRepository workFlowDefinitionRepository;
    private final WorkFlowExecutionFactory workFlowExecutionFactory;

    public WorkFlowExecutionAspect(WorkFlowSchedulerServiceImpl workFlowSchedulerService, WorkFlowDefinitionRepository workFlowDefinitionRepository, WorkFlowExecutionFactory workFlowExecutionFactory) {
        this.workFlowSchedulerService = workFlowSchedulerService;
        this.workFlowDefinitionRepository = workFlowDefinitionRepository;
        this.workFlowExecutionFactory = workFlowExecutionFactory;
    }

    @Pointcut(value="execution(* com.redhat.parodos.workflows.workflow.WorkFlow+.execute(..))")
    public void pointcutScope() {
    }

    @Around(value="pointcutScope() && args(workContext)")
    public WorkReport executeAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, WorkContext workContext) {
        WorkReport report;
        String workflowName = ((WorkFlow)proceedingJoinPoint.getTarget()).getName();
        log.info("Before invoking execute() on workflow: {} with workContext: {}", (Object)workflowName, (Object)workContext);
        WorkFlowDefinition workFlowDefinition = this.workFlowDefinitionRepository.findFirstByName(workflowName);
        WorkFlowExecutionInterceptor executionHandler = this.workFlowExecutionFactory.createExecutionHandler(workFlowDefinition, workContext);
        WorkFlowExecution workFlowExecution = executionHandler.handlePreWorkFlowExecution();
        if (workFlowExecution.getStatus().equals((Object)WorkFlowStatus.COMPLETED)) {
            if (workFlowDefinition.getType().equals((Object)WorkFlowType.CHECKER)) {
                this.workFlowSchedulerService.stop(workFlowExecution.getProjectId(), (WorkFlow)proceedingJoinPoint.getTarget());
            }
            log.info("skipping workflow: {} is already completed", (Object)workFlowDefinition.getName());
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        try {
            report = (WorkReport)proceedingJoinPoint.proceed();
            log.info("Workflow {} is {}!", (Object)workflowName, (Object)report.getStatus().name());
        }
        catch (Throwable e) {
            log.error("Workflow {} has failed! with error: {}", (Object)workflowName, (Object)e.getMessage());
            report = new DefaultWorkReport(WorkStatus.FAILED, workContext);
        }
        return executionHandler.handlePostWorkFlowExecution(report, (WorkFlow)proceedingJoinPoint.getTarget());
    }
}

