/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.execution.aspect;

import com.redhat.parodos.workflow.definition.entity.WorkFlowDefinition;
import com.redhat.parodos.workflow.definition.entity.WorkFlowTaskDefinition;
import com.redhat.parodos.workflow.enums.WorkFlowStatus;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowExecutionFactory;
import com.redhat.parodos.workflow.execution.aspect.WorkFlowPostInterceptor;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecutionContext;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import com.redhat.parodos.workflow.execution.service.WorkFlowServiceImpl;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentInfrastructureWorkFlowPostInterceptor
implements WorkFlowPostInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssessmentInfrastructureWorkFlowPostInterceptor.class);
    private final WorkFlowDefinition workFlowDefinition;
    private final WorkContext workContext;
    private final WorkFlowExecution workFlowExecution;
    private final WorkFlowExecution mainWorkFlowExecution;
    private final WorkFlowServiceImpl workFlowService;
    private final WorkFlowRepository workFlowRepository;

    public AssessmentInfrastructureWorkFlowPostInterceptor(WorkFlowDefinition workFlowDefinition, WorkContext workContext, WorkFlowServiceImpl workFlowService, WorkFlowRepository workFlowRepository, WorkFlowExecution workFlowExecution, WorkFlowExecution mainWorkFlowExecution) {
        this.workFlowDefinition = workFlowDefinition;
        this.workContext = workContext;
        this.workFlowService = workFlowService;
        this.workFlowRepository = workFlowRepository;
        this.workFlowExecution = workFlowExecution;
        this.mainWorkFlowExecution = mainWorkFlowExecution;
    }

    public WorkReport handlePostWorkFlowExecution() {
        DefaultWorkReport report = null;
        if (WorkFlowExecutionFactory.isMainWorkFlow((WorkFlowDefinition)this.workFlowDefinition, (WorkContext)this.workContext)) {
            this.workFlowExecution.setWorkFlowExecutionContext(Optional.ofNullable(this.workFlowExecution.getWorkFlowExecutionContext()).map(workFlowExecutionContext -> {
                workFlowExecutionContext.setWorkContext(this.workContext);
                return workFlowExecutionContext;
            }).orElse(WorkFlowExecutionContext.builder().mainWorkFlowExecution(this.workFlowExecution).workContext(this.workContext).build()));
        }
        if (this.workFlowExecution.getStatus() == WorkFlowStatus.FAILED) {
            this.workFlowService.updateWorkFlow(this.workFlowExecution);
            return null;
        }
        Set workFlowCheckerMappingDefinitions = this.workFlowDefinition.getWorkFlowTaskDefinitions().stream().map(WorkFlowTaskDefinition::getWorkFlowCheckerMappingDefinition).filter(Objects::nonNull).collect(Collectors.toSet());
        List checkerExecutions = workFlowCheckerMappingDefinitions.stream().map(workFlowCheckerDefinition -> this.workFlowRepository.findFirstByWorkFlowDefinitionIdAndMainWorkFlowExecution(workFlowCheckerDefinition.getCheckWorkFlow().getId(), this.mainWorkFlowExecution)).collect(Collectors.toList());
        for (WorkFlowExecution checkerExecution : checkerExecutions) {
            if (checkerExecution != null && checkerExecution.getStatus() == WorkFlowStatus.REJECTED) {
                log.info("fail workflow: {} because it has declined checker(s)", (Object)this.workFlowDefinition.getName());
                this.workFlowExecution.setStatus(WorkFlowStatus.FAILED);
                report = new DefaultWorkReport(WorkStatus.FAILED, this.workContext);
                break;
            }
            if (checkerExecution != null && checkerExecution.getStatus() != WorkFlowStatus.FAILED) continue;
            log.info("workflow: {} has a pending/running checker: {}", (Object)this.workFlowDefinition.getName(), (Object)(checkerExecution == null ? "checker is pending" : checkerExecution.getWorkFlowDefinitionId().toString()));
            this.workFlowExecution.setStatus(WorkFlowStatus.IN_PROGRESS);
            report = new DefaultWorkReport(WorkStatus.IN_PROGRESS, this.workContext);
        }
        this.workFlowService.updateWorkFlow(this.workFlowExecution);
        return report;
    }
}

