/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow;

import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.definition.dto.WorkDefinitionResponseDTO;
import com.redhat.parodos.workflow.definition.dto.WorkFlowDefinitionResponseDTO;
import com.redhat.parodos.workflow.enums.WorkType;
import com.redhat.parodos.workflow.execution.dto.WorkFlowRequestDTO;
import com.redhat.parodos.workflow.registry.BeanWorkFlowRegistryImpl;
import com.redhat.parodos.workflow.util.WorkFlowDTOUtil;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WorkFlowDelegate {
    private final BeanWorkFlowRegistryImpl beanWorkFlowRegistry;

    public WorkFlowDelegate(BeanWorkFlowRegistryImpl beanWorkFlowRegistry) {
        this.beanWorkFlowRegistry = beanWorkFlowRegistry;
    }

    public WorkContext initWorkFlowContext(WorkFlowRequestDTO workFlowRequestDTO, WorkFlowDefinitionResponseDTO mainWorkFlowDefinitionDto) {
        WorkContext workContext = new WorkContext();
        if (workFlowRequestDTO.getArguments() != null && !workFlowRequestDTO.getArguments().isEmpty()) {
            WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (String)workFlowRequestDTO.getWorkFlowName(), (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ARGUMENTS, (Object)WorkFlowDTOUtil.convertArgumentListToMap((List)workFlowRequestDTO.getArguments()));
        }
        if (mainWorkFlowDefinitionDto.getWorks() != null && !mainWorkFlowDefinitionDto.getWorks().isEmpty()) {
            mainWorkFlowDefinitionDto.getWorks().forEach(work -> this.initWorkContext(workContext, workFlowRequestDTO.findFirstWorkByName(work.getName()), work, mainWorkFlowDefinitionDto.getName()));
        }
        return workContext;
    }

    private void initWorkContext(WorkContext workContext, WorkFlowRequestDTO.WorkRequestDTO workRequestDTO, WorkDefinitionResponseDTO workDefinitionResponseDTO, String parentWorkflowName) {
        WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, (String)workDefinitionResponseDTO.getName(), (WorkContextDelegate.Resource)WorkContextDelegate.Resource.PARENT_WORKFLOW, (Object)parentWorkflowName);
        Optional.ofNullable(workRequestDTO).filter(dto -> !CollectionUtils.isEmpty((Collection)dto.getArguments())).ifPresent(dto -> WorkContextDelegate.write((WorkContext)workContext, (WorkContextDelegate.ProcessType)(WorkType.WORKFLOW.name().equalsIgnoreCase(dto.getType()) ? WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION : WorkContextDelegate.ProcessType.WORKFLOW_TASK_EXECUTION), (String)workRequestDTO.getWorkName(), (WorkContextDelegate.Resource)WorkContextDelegate.Resource.ARGUMENTS, (Object)WorkFlowDTOUtil.convertArgumentListToMap((List)workRequestDTO.getArguments())));
        if (workDefinitionResponseDTO.getWorks() != null) {
            workDefinitionResponseDTO.getWorks().forEach(work -> this.initWorkContext(workContext, (WorkFlowRequestDTO.WorkRequestDTO)Optional.ofNullable(workRequestDTO).map(dto -> dto.findFirstWorkByName(work.getName())).orElse(null), work, workDefinitionResponseDTO.getName()));
        }
    }

    public WorkFlow getWorkFlowExecutionByName(String workFlowName) {
        return this.beanWorkFlowRegistry.getWorkFlowByName(workFlowName);
    }
}

