/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.user.service;

import com.redhat.parodos.user.dto.UserResponseDTO;
import com.redhat.parodos.user.entity.User;
import com.redhat.parodos.user.repository.UserRepository;
import com.redhat.parodos.user.service.UserService;
import java.util.Optional;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class UserServiceImpl
implements UserService {
    private final UserRepository userRepository;
    private final ModelMapper modelMapper;

    public UserServiceImpl(UserRepository userRepository, ModelMapper modelMapper) {
        this.userRepository = userRepository;
        this.modelMapper = modelMapper;
    }

    public UserResponseDTO save(User user) {
        return (UserResponseDTO)this.modelMapper.map(this.userRepository.save((Object)user), UserResponseDTO.class);
    }

    public UserResponseDTO getUserById(UUID id) {
        return (UserResponseDTO)this.modelMapper.map(this.userRepository.findById((Object)id).orElseThrow(() -> new RuntimeException(String.format("User with id: %s not found", id))), UserResponseDTO.class);
    }

    public UserResponseDTO getUserByUsername(String username) {
        Optional user = this.userRepository.findByUsername(username);
        if (!user.isPresent()) {
            throw new RuntimeException(String.format("User with username: %s not found", username));
        }
        return (UserResponseDTO)this.modelMapper.map(user.get(), UserResponseDTO.class);
    }

    public User getUserEntityByUsername(String username) {
        return (User)this.userRepository.findByUsername(username).stream().findFirst().orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, "user " + username + " is not found"));
    }
}

