/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.project.service;

import com.redhat.parodos.project.dto.ProjectRequestDTO;
import com.redhat.parodos.project.dto.ProjectResponseDTO;
import com.redhat.parodos.project.entity.Project;
import com.redhat.parodos.project.repository.ProjectRepository;
import com.redhat.parodos.project.service.ProjectService;
import com.redhat.parodos.security.SecurityUtils;
import com.redhat.parodos.user.service.UserService;
import com.redhat.parodos.workflow.execution.entity.WorkFlowExecution;
import com.redhat.parodos.workflow.execution.repository.WorkFlowRepository;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.EntityExistsException;
import org.modelmapper.ModelMapper;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ProjectServiceImpl
implements ProjectService {
    private final ProjectRepository projectRepository;
    private final WorkFlowRepository workFlowRepository;
    private final UserService userService;
    private final ModelMapper modelMapper;

    public ProjectServiceImpl(ProjectRepository projectRepository, WorkFlowRepository workFlowRepository, UserService userService, ModelMapper modelMapper) {
        this.projectRepository = projectRepository;
        this.workFlowRepository = workFlowRepository;
        this.userService = userService;
        this.modelMapper = modelMapper;
    }

    public ProjectResponseDTO save(ProjectRequestDTO projectRequestDTO) {
        Optional projectByName = this.projectRepository.findByNameIgnoreCase(projectRequestDTO.getName());
        if (projectByName.isPresent()) {
            throw new EntityExistsException(String.format("Project with name: %s already exists", ((Project)projectByName.get()).getName()));
        }
        Project project = (Project)this.projectRepository.save((Object)Project.builder().name(projectRequestDTO.getName()).description(projectRequestDTO.getDescription()).createDate(new Date()).modifyDate(new Date()).user(this.userService.getUserEntityByUsername(SecurityUtils.getUsername())).build());
        return (ProjectResponseDTO)this.modelMapper.map((Object)project, ProjectResponseDTO.class);
    }

    public ProjectResponseDTO getProjectById(UUID id) {
        return (ProjectResponseDTO)this.modelMapper.map(this.projectRepository.findById((Object)id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("Project with id: %s not found", id))), ProjectResponseDTO.class);
    }

    public List<ProjectResponseDTO> getProjects() {
        List projects = this.projectRepository.findAll();
        return projects.stream().map(project -> {
            WorkFlowExecution workFlowExecution = this.workFlowRepository.findFirstByProjectIdAndMainWorkFlowExecutionIsNullOrderByStartDateDesc(project.getId());
            return ProjectResponseDTO.builder().id(project.getId()).name(project.getName()).createDate(project.getCreateDate()).modifyDate(project.getModifyDate()).description(project.getDescription()).status(null == workFlowExecution ? "" : workFlowExecution.getStatus().name()).build();
        }).toList();
    }

    public ProjectResponseDTO getProjectByIdAndUsername(UUID id, String username) {
        return (ProjectResponseDTO)this.modelMapper.map(this.projectRepository.findByIdAndUserUsername(id, username).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("Project with id: %s not found for user: %s", id, SecurityUtils.getUsername()))), ProjectResponseDTO.class);
    }

    public List<ProjectResponseDTO> findProjectsByUserName(String username) {
        return this.projectRepository.findAllByUserUsername(username).stream().map(project -> (ProjectResponseDTO)this.modelMapper.map(project, ProjectResponseDTO.class)).toList();
    }
}

