/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.project.controller;

import com.redhat.parodos.project.dto.ProjectRequestDTO;
import com.redhat.parodos.project.dto.ProjectResponseDTO;
import com.redhat.parodos.project.service.ProjectServiceImpl;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@CrossOrigin(origins={"*"}, maxAge=1800L)
@RestController
@RequestMapping(value={"/api/v1/projects"})
@Tag(name="Project", description="Operations about project")
public class ProjectController {
    private final ProjectServiceImpl projectService;

    public ProjectController(ProjectServiceImpl projectService) {
        this.projectService = projectService;
    }

    @Operation(summary="Creates a new project")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Created", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectResponseDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content})})
    @PostMapping
    public ResponseEntity<ProjectResponseDTO> createProject(@Valid @RequestBody ProjectRequestDTO projectRequestDTO) {
        ProjectResponseDTO projectResponseDTO = this.projectService.save(projectRequestDTO);
        URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{projectResponseDTO.getId()}).toUri();
        return ResponseEntity.created((URI)location).body((Object)projectResponseDTO);
    }

    @Operation(summary="Returns a list of project")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ProjectResponseDTO.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @GetMapping
    public ResponseEntity<List<ProjectResponseDTO>> getProjects() {
        return ResponseEntity.ok((Object)this.projectService.getProjects());
    }

    @Operation(summary="Returns information about a specified project")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Succeeded", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProjectResponseDTO.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="404", description="Not found", content={@Content})})
    @GetMapping(value={"/{id}"})
    public ResponseEntity<ProjectResponseDTO> getProjectById(@PathVariable UUID id) {
        ProjectResponseDTO projectResponseDTO = this.projectService.getProjectById(id);
        if (projectResponseDTO == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)projectResponseDTO);
    }
}

