/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.base.internal.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.nokee.runtime.base.internal.repositories.AbstractRouteHandler;
import dev.nokee.runtime.base.internal.repositories.GradleModuleMetadata;
import dev.nokee.runtime.base.internal.tools.CommandLineToolDescriptor;
import dev.nokee.runtime.base.internal.tools.ToolRepository;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ToolRouteHandler
extends AbstractRouteHandler {
    private static final Logger LOGGER = Logger.getLogger(ToolRouteHandler.class.getName());
    public static final String CONTEXT_PATH = "/dev/nokee/tool";
    private final ToolRepository toolRepository;

    @Inject
    public ToolRouteHandler(ToolRepository toolRepository) {
        this.toolRepository = toolRepository;
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }

    @Override
    public boolean isKnownModule(String moduleName) {
        return this.toolRepository.getKnownTools().contains(moduleName);
    }

    @Override
    public boolean isKnownVersion(String moduleName, String version) {
        return this.toolRepository.findAll(moduleName).stream().anyMatch(it -> it.getPath().getName().equals(moduleName) && it.getVersion().toString().equals(version));
    }

    @Override
    public List<String> findVersions(String moduleName) {
        return this.toolRepository.findAll(moduleName).stream().filter(it -> it.getPath().getName().equals(moduleName)).map(it -> it.getVersion().toString()).collect(Collectors.toList());
    }

    @Override
    public GradleModuleMetadata getResourceMetadata(String moduleName, String version) {
        CommandLineToolDescriptor descriptor = this.toolRepository.findAll(moduleName).stream().filter(it -> it.getPath().getName().equals(moduleName) && it.getVersion().toString().equals(version)).findFirst().get();
        String content = this.serialize(descriptor);
        GradleModuleMetadata.Variant.File file = new GradleModuleMetadata.Variant.File(moduleName + ".tooldescriptor", moduleName + ".tooldescriptor", String.valueOf(content.getBytes().length), Hashing.sha1().hashString((CharSequence)content, Charset.defaultCharset()).toString(), Hashing.md5().hashString((CharSequence)content, Charset.defaultCharset()).toString());
        List<GradleModuleMetadata.Variant.Capability> capabilities = Collections.singletonList(new GradleModuleMetadata.Variant.Capability("dev.nokee.tool", moduleName, version));
        ImmutableMap attributes = ImmutableMap.builder().build();
        return GradleModuleMetadata.of(GradleModuleMetadata.Component.of("dev.nokee.tool", moduleName, version), (List<GradleModuleMetadata.Variant>)ImmutableList.of((Object)new GradleModuleMetadata.Variant(moduleName, (Map<String, Object>)attributes, Collections.singletonList(file), capabilities)));
    }

    @Override
    public String handle(String moduleName, String version, String target) {
        if (target.endsWith(".tooldescriptor")) {
            CommandLineToolDescriptor descriptor = this.toolRepository.findAll(moduleName).stream().filter(it -> it.getPath().getName().equals(moduleName) && it.getVersion().toString().equals(version)).findFirst().get();
            return this.serialize(descriptor);
        }
        return null;
    }

    private String serialize(CommandLineToolDescriptor descriptor) {
        return new GsonBuilder().registerTypeAdapter(File.class, (Object)new JsonSerializer<File>(){

            public JsonElement serialize(File src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.getAbsolutePath());
            }
        }).create().toJson((Object)descriptor);
    }
}

